/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidContentEntriesSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ContentEntriesSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentRootsModuleSetupStep
extends AndroidModuleSetupStep {
    @NotNull
    private final AndroidContentEntriesSetup.Factory myContentEntriesSetupFactory;

    public ContentRootsModuleSetupStep() {
        this(new AndroidContentEntriesSetup.Factory());
    }

    @VisibleForTesting
    ContentRootsModuleSetupStep(@NotNull AndroidContentEntriesSetup.Factory contentEntriesSetupFactory) {
        this.myContentEntriesSetupFactory = contentEntriesSetupFactory;
    }

    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull AndroidModuleModel androidModel) {
        ModifiableRootModel moduleModel = context.getModifiableRootModel();
        boolean hasNativeModel = context.hasNativeModel();
        AndroidContentEntriesSetup setup2 = this.myContentEntriesSetupFactory.create(androidModel, moduleModel, hasNativeModel);
        List<ContentEntry> contentEntries = ContentRootsModuleSetupStep.findContentEntries(moduleModel, androidModel, hasNativeModel);
        setup2.execute(contentEntries);
    }

    @NotNull
    private static List<ContentEntry> findContentEntries(@NotNull ModifiableRootModel moduleModel, @NotNull AndroidModuleModel androidModel, boolean hasNativeModel) {
        if (!hasNativeModel) {
            ContentEntriesSetup.removeExistingContentEntries(moduleModel);
        }
        ArrayList<ContentEntry> contentEntries = new ArrayList<ContentEntry>();
        ContentEntry contentEntry = moduleModel.addContentEntry(androidModel.getRootDir());
        contentEntries.add(contentEntry);
        return contentEntries;
    }

    private static boolean hasNativeModel(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @Nullable GradleModuleModels gradleModels) {
        if (gradleModels != null) {
            return gradleModels.findModel(NativeAndroidProject.class) != null;
        }
        NdkFacet facet = (NdkFacet)((Object)Facets.findFacet(module, ideModelsProvider, NdkFacet.getFacetType().getId()));
        return facet != null && facet.getNdkModuleModel() != null;
    }

    @Override
    public boolean invokeOnBuildVariantChange() {
        return true;
    }

    @Override
    public boolean invokeOnSkippedSync() {
        return true;
    }
}

