/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkModuleSetupStep
extends AndroidModuleSetupStep {
    @NotNull
    private final AndroidSdks myAndroidSdks;

    public SdkModuleSetupStep() {
        this(AndroidSdks.getInstance());
    }

    @VisibleForTesting
    SdkModuleSetupStep(@NotNull AndroidSdks androidSdks) {
        this.myAndroidSdks = androidSdks;
    }

    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull AndroidModuleModel androidModel) {
        IdeAndroidProject androidProject;
        String compileTarget;
        Sdk sdk;
        File androidSdkHomePath = IdeSdks.getInstance().getAndroidSdkPath();
        if (androidSdkHomePath == null) {
            assert (!IdeInfo.getInstance().isAndroidStudio());
            SdkModuleSetupStep.logAndroidSdkHomeNotFound();
            return;
        }
        ModifiableRootModel moduleModel = context.getModifiableRootModel();
        LanguageLevel languageLevel = androidModel.getJavaLanguageLevel();
        if (languageLevel != null) {
            ((LanguageLevelModuleExtensionImpl)moduleModel.getModuleExtension(LanguageLevelModuleExtensionImpl.class)).setLanguageLevel(languageLevel);
        }
        if ((sdk = this.myAndroidSdks.findSuitableAndroidSdk(compileTarget = (androidProject = androidModel.getAndroidProject()).getCompileTarget())) == null) {
            AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SdkModuleSetupStep.class);
            sdkHandler.getSdkManager((ProgressIndicator)progress).reloadLocalIfNeeded((ProgressIndicator)progress);
            Sdk[] finalSdk = new Sdk[1];
            ApplicationManager.getApplication().invokeAndWait(() -> {
                finalSdk[0] = (Sdk)ApplicationManager.getApplication().runWriteAction(() -> this.myAndroidSdks.tryToCreate(androidSdkHomePath, compileTarget));
            });
            sdk = finalSdk[0];
            if (sdk == null) {
                sdk = this.findMatchingSdkForAddon((AndroidProject)androidProject);
            }
        }
        Module module = context.getModule();
        if (sdk == null) {
            SdkModuleSetupStep.showPlatformNotFoundError(module, compileTarget);
            return;
        }
        moduleModel.setSdk(sdk);
        String sdkPath = sdk.getHomePath();
        if (sdkPath == null) {
            sdkPath = "<path not set>";
        }
        SdkModuleSetupStep.getLog().info(String.format("Set Android SDK '%1$s' (%2$s) to module '%3$s'", sdk.getName(), sdkPath, module.getName()));
    }

    private static void logAndroidSdkHomeNotFound() {
        Logger log = SdkModuleSetupStep.getLog();
        log.warn("Path to Android SDK not set");
        List<Sdk> sdks = IdeSdks.getInstance().getEligibleAndroidSdks();
        log.warn("# of eligible SDKs: " + sdks.size());
        for (Sdk sdk : sdks) {
            log.info("sdk: " + sdk.toString());
        }
    }

    private static void showPlatformNotFoundError(@NotNull Module module, @NotNull String compileTarget) {
        String text = String.format("Module '%1$s': platform '%2$s' not found.", module.getName(), compileTarget);
        SdkModuleSetupStep.getLog().warn(text);
        SyncMessage msg = new SyncMessage("SDK Setup Issues", MessageType.ERROR, text);
        GradleSyncMessages.getInstance(module.getProject()).report(msg);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(SdkModuleSetupStep.class);
    }

    @Nullable
    private Sdk findMatchingSdkForAddon(@NotNull AndroidProject androidProject) {
        File androidJarPath;
        Collection bootClasspath = androidProject.getBootClasspath();
        if (bootClasspath.size() > 1 && (androidJarPath = SdkModuleSetupStep.findAndroidJarFilePath(bootClasspath)) != null) {
            return this.findSdk(androidJarPath);
        }
        return null;
    }

    @Nullable
    private static File findAndroidJarFilePath(@NotNull Collection<String> bootClasspath) {
        for (String entry : bootClasspath) {
            File file = new File(entry);
            if (!"android.jar".equals(file.getName())) continue;
            return file;
        }
        return null;
    }

    @Nullable
    private Sdk findSdk(@NotNull File androidJarPath) {
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            if (!SdkModuleSetupStep.containsPath(sdk, androidJarPath)) continue;
            return sdk;
        }
        return null;
    }

    private static boolean containsPath(@NotNull Sdk sdk, @NotNull File path) {
        for (VirtualFile sdkFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            File sdkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile);
            if (!FileUtil.filesEqual((File)sdkFilePath, (File)path)) continue;
            return true;
        }
        return false;
    }
}

