/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleSetupStep;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSetup<T extends ModuleSetupStep<M>, M> {
    protected final T[] mySetupSteps;

    protected BaseSetup(T ... steps) {
        this.mySetupSteps = steps;
    }

    protected boolean shouldRunSyncStep(@NotNull T step, boolean syncSkipped) {
        return !syncSkipped || ((ModuleSetupStep)step).invokeOnSkippedSync();
    }

    protected void beforeSetup(@NotNull ModuleSetupContext context, @Nullable M model2, boolean syncSkipped) {
    }

    public void setUpModule(@NotNull ModuleSetupContext context, @Nullable M model2, boolean syncSkipped) {
        this.beforeSetup(context, model2, syncSkipped);
        for (M step : this.mySetupSteps) {
            if (!this.shouldRunSyncStep(step, syncSkipped)) continue;
            ((ModuleSetupStep)step).setUpModule(context, model2);
            if (!((ModuleSetupStep)step).shouldTerminateSetup()) continue;
            return;
        }
    }
}

