/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencySetupIssues {
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final GradleSyncMessages mySyncMessages;
    @NotNull
    private final Map<String, MissingModule> myMissingModules = new ConcurrentHashMap<String, MissingModule>();
    @NotNull
    private final Map<String, MissingModule> myMissingModulesWithBackupLibraries = new ConcurrentHashMap<String, MissingModule>();
    @NotNull
    private final Set<String> myDependentsOnLibrariesWithoutBinaryPath = new CopyOnWriteArraySet<String>();
    @NotNull
    private final Set<InvalidModuleDependency> myInvalidModuleDependencies = new CopyOnWriteArraySet<InvalidModuleDependency>();

    @NotNull
    public static DependencySetupIssues getInstance(@NotNull Project project) {
        return (DependencySetupIssues)ServiceManager.getService((Project)project, DependencySetupIssues.class);
    }

    public DependencySetupIssues(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleSyncMessages syncMessages) {
        this.mySyncState = syncState;
        this.mySyncMessages = syncMessages;
    }

    public void reportIssues() {
        String msg;
        this.reportModulesNotFoundIssues(this.getMissingModules());
        for (String dependent : this.getDependentsOnLibrariesWithoutBinaryPath()) {
            msg = String.format("Module '%1$s' depends on libraries that do not have a 'binary' path.", dependent);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.ERROR, msg));
        }
        for (InvalidModuleDependency dependency : this.myInvalidModuleDependencies) {
            msg = String.format("Ignoring dependency of module '%1$s' on module '%2$s'. %3$s", dependency.dependent, dependency.dependency.getName(), dependency.cause);
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(dependency.dependency);
            assert (buildFile != null);
            OpenFileDescriptor navigatable = new OpenFileDescriptor(dependency.dependency.getProject(), buildFile, 0);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.WARNING, (Navigatable)navigatable, msg));
        }
        this.reportModulesNotFoundIssues(this.getMissingModulesWithBackupLibraries());
        this.clear();
    }

    @VisibleForTesting
    @NotNull
    List<MissingModule> getMissingModules() {
        return DependencySetupIssues.getMissingModules(this.myMissingModules);
    }

    @VisibleForTesting
    @NotNull
    List<MissingModule> getMissingModulesWithBackupLibraries() {
        return DependencySetupIssues.getMissingModules(this.myMissingModulesWithBackupLibraries);
    }

    @NotNull
    private static List<MissingModule> getMissingModules(@NotNull Map<String, MissingModule> missingModulesByName) {
        if (missingModulesByName.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MissingModule> missingModules = new ArrayList<MissingModule>();
        ArrayList<String> names = new ArrayList<String>(missingModulesByName.keySet());
        if (names.size() > 1) {
            names.sort(String::compareTo);
        }
        for (String name : names) {
            MissingModule missingModule = missingModulesByName.get(name);
            missingModule.sortDependentNames();
            missingModules.add(missingModule);
        }
        return missingModules;
    }

    @VisibleForTesting
    @NotNull
    List<String> getDependentsOnLibrariesWithoutBinaryPath() {
        return DependencySetupIssues.sortSet(this.myDependentsOnLibrariesWithoutBinaryPath);
    }

    @NotNull
    private static List<String> sortSet(@NotNull Set<String> set) {
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> sorted = new ArrayList<String>(set);
        if (sorted.size() > 1) {
            sorted.sort(String::compareTo);
        }
        return sorted;
    }

    private void reportModulesNotFoundIssues(@NotNull List<MissingModule> missingModules) {
        if (!missingModules.isEmpty()) {
            for (MissingModule missingModule : missingModules) {
                ArrayList<String> messageLines = new ArrayList<String>();
                StringBuilder text = new StringBuilder();
                text.append(String.format("Unable to find module with Gradle path '%1$s' (needed by module", missingModule.dependencyPath));
                DependencySetupIssues.addDependentsToText(text, missingModule.dependentNames);
                text.append(".)");
                messageLines.add(text.toString());
                String backupLibraryName = missingModule.backupLibraryName;
                if (StringUtil.isNotEmpty((String)backupLibraryName)) {
                    String msg = String.format("Linking to library '%1$s' instead.", backupLibraryName);
                    messageLines.add(msg);
                }
                this.mySyncMessages.report(new SyncMessage("Missing Dependencies", missingModule.issueType, ArrayUtil.toStringArray(messageLines)));
            }
        }
    }

    private static void addDependentsToText(@NotNull StringBuilder text, @NotNull List<String> dependents) {
        assert (!dependents.isEmpty());
        if (dependents.size() == 1) {
            text.append(String.format(" '%1$s'", dependents.get(0)));
            return;
        }
        text.append("s: ");
        int i2 = 0;
        for (String dependent : dependents) {
            if (i2++ > 0) {
                text.append(", ");
            }
            text.append(String.format("'%1$s'", dependent));
        }
    }

    private void clear() {
        this.myMissingModules.clear();
        this.myMissingModulesWithBackupLibraries.clear();
        this.myDependentsOnLibrariesWithoutBinaryPath.clear();
        this.myInvalidModuleDependencies.clear();
    }

    public void addMissingModule(@NotNull String dependencyName, @NotNull String dependentName, @Nullable String backupLibraryName) {
        Map<String, MissingModule> mapping = StringUtil.isNotEmpty((String)backupLibraryName) ? this.myMissingModulesWithBackupLibraries : this.myMissingModules;
        MissingModule missingModule = mapping.computeIfAbsent(dependencyName, name -> new MissingModule((String)name, backupLibraryName));
        missingModule.addDependent(dependentName);
        if (missingModule.isError()) {
            this.registerSyncError();
        }
    }

    public void addMissingBinaryPath(@NotNull String dependentName) {
        this.myDependentsOnLibrariesWithoutBinaryPath.add(dependentName);
        this.registerSyncError();
    }

    private void registerSyncError() {
        this.mySyncState.getSummary().setSyncErrorsFound(true);
    }

    public void addInvalidModuleDependency(@NotNull Module dependency, @NotNull String dependent, @NotNull String cause) {
        this.myInvalidModuleDependencies.add(new InvalidModuleDependency(dependency, dependent, cause));
    }

    @VisibleForTesting
    static class InvalidModuleDependency {
        @NotNull
        final Module dependency;
        @NotNull
        final String dependent;
        @NotNull
        final String cause;

        InvalidModuleDependency(@NotNull Module dependency, @NotNull String dependent, @NotNull String cause) {
            this.dependency = dependency;
            this.dependent = dependent;
            this.cause = cause;
        }
    }

    @VisibleForTesting
    static class MissingModule {
        @NotNull
        final String dependencyPath;
        @NotNull
        final MessageType issueType;
        @Nullable
        final String backupLibraryName;
        @NotNull
        final List<String> dependentNames = new CopyOnWriteArrayList<String>();

        MissingModule(@NotNull String dependencyPath, @Nullable String backupLibraryName) {
            this.dependencyPath = dependencyPath;
            this.backupLibraryName = backupLibraryName;
            this.issueType = StringUtil.isEmpty((String)backupLibraryName) ? MessageType.ERROR : MessageType.WARNING;
        }

        void addDependent(@NotNull String dependentName) {
            this.dependentNames.add(dependentName);
        }

        void sortDependentNames() {
            if (!this.dependentNames.isEmpty()) {
                this.dependentNames.sort(String::compareTo);
            }
        }

        boolean isError() {
            return this.issueType == MessageType.ERROR;
        }
    }
}

