/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleDependenciesSetup {
    private static final Logger LOG = Logger.getInstance(ModuleDependenciesSetup.class);

    protected void updateLibraryRootTypePaths(@NotNull Library library, @NotNull OrderRootType pathType, @NotNull IdeModifiableModelsProvider modelsProvider, File ... paths2) {
        if (paths2.length == 0) {
            return;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        for (File path : paths2) {
            libraryModel.addRoot(FilePaths.pathToIdeaUrl((File)path), pathType);
        }
    }

    protected void addLibraryAsDependency(@NotNull Library library, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, boolean exported) {
        for (OrderEntry orderEntry : modelsProvider.getModifiableRootModel(module).getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            Library entryLibrary = ((LibraryOrderEntry)orderEntry).getLibrary();
            DependencyScope entryScope = ((LibraryOrderEntry)orderEntry).getScope();
            if (entryLibrary == null || !libraryName.equals(entryLibrary.getName()) || !scope.equals((Object)entryScope)) continue;
            return;
        }
        LibraryOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module).addLibraryEntry(library);
        orderEntry.setScope(scope);
        orderEntry.setExported(exported);
        ModuleDependenciesSetup.updateLibraryRootsInFileSystem(orderEntry);
    }

    private static void updateLibraryRootsInFileSystem(@NotNull LibraryOrderEntry orderEntry) {
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            for (String url : orderEntry.getUrls(type)) {
                VirtualFile file = manager.findFileByUrl(url);
                if (file == null) {
                    file = manager.refreshAndFindFileByUrl(url);
                }
                if (file != null || !LOG.isDebugEnabled()) continue;
                LOG.debug(String.format("Can't find %s of the library '%s' at path '%s'", type, orderEntry.getLibraryName(), url));
            }
        }
    }
}

