/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class DependenciesExtractor {
    @NotNull
    public static DependenciesExtractor getInstance() {
        return (DependenciesExtractor)ServiceManager.getService(DependenciesExtractor.class);
    }

    @NotNull
    public DependencySet extractFrom(@NotNull IdeVariant variant, @NotNull ModuleFinder moduleFinder) {
        DependencySet dependencies = new DependencySet();
        for (IdeBaseArtifact testArtifact : variant.getTestArtifacts()) {
            DependenciesExtractor.populate(dependencies, testArtifact, moduleFinder, DependencyScope.TEST);
        }
        IdeAndroidArtifact mainArtifact = variant.getMainArtifact();
        DependenciesExtractor.populate(dependencies, (IdeBaseArtifact)mainArtifact, moduleFinder, DependencyScope.COMPILE);
        return dependencies;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull IdeBaseArtifact artifact, @NotNull DependencyScope scope, @NotNull ModuleFinder moduleFinder) {
        DependencySet dependencies = new DependencySet();
        DependenciesExtractor.populate(dependencies, artifact, moduleFinder, scope);
        return dependencies;
    }

    private static void populate(@NotNull DependencySet dependencies, @NotNull IdeBaseArtifact artifact, @NotNull ModuleFinder moduleFinder, @NotNull DependencyScope scope) {
        IdeDependencies artifactDependencies = artifact.getLevel2Dependencies();
        for (Library library : artifactDependencies.getJavaLibraries()) {
            LibraryDependency libraryDependency = new LibraryDependency(library.getArtifact(), library.getArtifactAddress(), scope);
            libraryDependency.addBinaryPath(library.getArtifact());
            dependencies.add(libraryDependency);
        }
        for (Library library : artifactDependencies.getAndroidLibraries()) {
            dependencies.add(DependenciesExtractor.createLibraryDependencyFromAndroidLibrary(library, scope));
        }
        for (Library library : artifactDependencies.getModuleDependencies()) {
            String gradlePath = library.getProjectPath();
            if (!StringUtil.isNotEmpty((String)gradlePath)) continue;
            Module module = null;
            String moduleId = gradlePath;
            String projectFolderPath = library.getBuildId();
            if (StringUtil.isNotEmpty((String)projectFolderPath)) {
                moduleId = Modules.createUniqueModuleId(projectFolderPath, gradlePath);
                module = moduleFinder.findModuleByModuleId(moduleId);
            }
            if (module == null) {
                moduleId = gradlePath;
                module = moduleFinder.findModuleByGradlePath(moduleId);
            }
            ModuleDependency dependency = new ModuleDependency(moduleId, scope, module);
            dependencies.add(dependency);
        }
    }

    @NotNull
    private static LibraryDependency createLibraryDependencyFromAndroidLibrary(@NotNull Library library, @NotNull DependencyScope scope) {
        LibraryDependency dependency = new LibraryDependency(library.getArtifact(), library.getArtifactAddress(), scope);
        dependency.addBinaryPath(library.getCompileJarFile());
        dependency.addBinaryPath(library.getResFolder());
        for (String localJar : library.getLocalJars()) {
            dependency.addBinaryPath(localJar);
        }
        return dependency;
    }

    @NotNull
    public static String getDependencyDisplayName(@NotNull Library library) {
        String artifactAddress = library.getArtifactAddress();
        GradleCoordinate coordinates = GradleCoordinate.parseCoordinateString((String)artifactAddress);
        if (coordinates != null) {
            GradleVersion version2;
            int index;
            String groupSuffix;
            String groupId;
            String name = coordinates.getArtifactId();
            if (name == null) {
                name = "?";
            }
            if (!name.contains("-") && (groupId = coordinates.getGroupId()) != null && !(groupSuffix = groupId.substring((index = groupId.lastIndexOf(46)) + 1)).equals(name)) {
                name = groupSuffix + ":" + name;
            }
            if ((version2 = coordinates.getVersion()) != null && !"unspecified".equals(version2.toString())) {
                name = name + ":" + version2;
            }
            return name;
        }
        return StringUtil.trimLeading((String)artifactAddress, (char)':');
    }
}

