/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.io.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class LibraryDependency
extends Dependency {
    @NotNull
    public static final String NAME_PREFIX = GradleConstants.SYSTEM_ID.getReadableName() + ": ";
    @NotNull
    private final Collection<File> myBinaryPaths = new LinkedHashSet<File>();
    @NotNull
    private final File myArtifactPath;
    private String myName;

    @VisibleForTesting
    public LibraryDependency(@NotNull File artifactPath, @NotNull DependencyScope scope) {
        this(artifactPath, FileUtil.getNameWithoutExtension((File)artifactPath), scope);
        this.addBinaryPath(artifactPath);
    }

    LibraryDependency(@NotNull File artifactPath, @NotNull String name, @NotNull DependencyScope scope) {
        super(scope);
        this.myArtifactPath = artifactPath;
        this.setName(name);
    }

    void addBinaryPath(@NotNull File path) {
        this.myBinaryPaths.add(path);
    }

    void addBinaryPath(@NotNull String path) {
        this.addBinaryPath(FilePaths.toSystemDependentPath((String)path));
    }

    @NotNull
    public File[] getBinaryPaths() {
        return this.myBinaryPaths.isEmpty() ? ArrayUtilRt.EMPTY_FILE_ARRAY : this.myBinaryPaths.toArray(new File[0]);
    }

    @NotNull
    public File getArtifactPath() {
        return this.myArtifactPath;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    void setName(@NotNull String name) {
        this.myName = name.isEmpty() || StringUtil.startsWith((CharSequence)name, (CharSequence)NAME_PREFIX) ? name : NAME_PREFIX + name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryDependency)) {
            return false;
        }
        LibraryDependency that = (LibraryDependency)o;
        return Objects.equals(this.myBinaryPaths, that.myBinaryPaths) && Objects.equals(this.myArtifactPath, that.myArtifactPath) && Objects.equals(this.myName, that.myName);
    }

    public int hashCode() {
        return Objects.hash(this.myBinaryPaths, this.myArtifactPath, this.myName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name='" + this.myName + '\'' + ", scope=" + this.getScope() + ", pathsByType=" + this.myBinaryPaths + "]";
    }
}

