/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependency
extends Dependency {
    @NotNull
    private final String myGradlePath;
    @Nullable
    private final Module myModule;
    @Nullable
    private LibraryDependency myBackupDependency;

    @VisibleForTesting
    public ModuleDependency(@NotNull String gradlePath, @NotNull DependencyScope scope, @Nullable Module module) {
        super(scope);
        this.myGradlePath = gradlePath;
        this.myModule = module;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    private boolean hasEqualPath(@NotNull GradleFacet facet) {
        String gradlePath = ((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH;
        return StringUtil.isNotEmpty((String)gradlePath) && gradlePath.equals(this.getGradlePath());
    }

    @NotNull
    public String getGradlePath() {
        return this.myGradlePath;
    }

    @Nullable
    public LibraryDependency getBackupDependency() {
        return this.myBackupDependency;
    }

    @VisibleForTesting
    public void setBackupDependency(@Nullable LibraryDependency backupDependency) {
        this.myBackupDependency = backupDependency;
        this.updateBackupDependencyScope();
    }

    @Override
    void setScope(@NotNull DependencyScope scope) throws IllegalArgumentException {
        super.setScope(scope);
        this.updateBackupDependencyScope();
    }

    private void updateBackupDependencyScope() {
        if (this.myBackupDependency != null) {
            this.myBackupDependency.setScope(this.getScope());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleDependency)) {
            return false;
        }
        ModuleDependency that = (ModuleDependency)o;
        return Objects.equals(this.myGradlePath, that.myGradlePath) && Objects.equals(this.myBackupDependency, that.myBackupDependency);
    }

    public int hashCode() {
        return Objects.hash(this.myGradlePath, this.myBackupDependency);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[gradlePath=" + this.myGradlePath + ", scope=" + this.getScope() + ", backUpDependency=" + this.myBackupDependency + "]";
    }
}

