/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea.java;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.JavaModuleDependenciesSetup;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArtifactsByConfigurationModuleSetupStep
extends JavaModuleSetupStep {
    @NotNull
    private final JavaModuleDependenciesSetup myDependenciesSetup = new JavaModuleDependenciesSetup();

    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull JavaModuleModel javaModuleModel) {
        Module module = context.getModule();
        IdeModifiableModelsProvider ideModelsProvider = context.getIdeModelsProvider();
        for (Map.Entry<String, Set<File>> entry : javaModuleModel.getArtifactsByConfiguration().entrySet()) {
            Set<File> artifacts = entry.getValue();
            if (artifacts == null || artifacts.isEmpty()) continue;
            for (File artifact : artifacts) {
                if (!artifact.isFile() || !StringUtil.endsWithIgnoreCase((String)artifact.getName(), (String)".jar")) continue;
                File buildFolderPath = javaModuleModel.getBuildFolderPath();
                String artifactName = FileUtil.getNameWithoutExtension((File)artifact);
                if (buildFolderPath != null && buildFolderPath.isDirectory() && FileUtil.isAncestor((File)buildFolderPath, (File)artifact, (boolean)true) && module.getName().equals(artifactName)) continue;
                String libraryName = module.getName() + "." + artifactName;
                this.myDependenciesSetup.setUpLibraryDependency(module, ideModelsProvider, libraryName, DependencyScope.COMPILE, artifact, null, null, true);
            }
        }
    }
}

