/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea.java;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetupStep;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class CheckAndroidModuleWithoutVariantsStep
extends JavaModuleSetupStep {
    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull JavaModuleModel gradleModel) {
        Module module = context.getModule();
        if (gradleModel.isAndroidModuleWithoutVariants()) {
            if (gradleModel.getSyncIssues().isEmpty()) {
                GradleSyncMessages messages = GradleSyncMessages.getInstance(module.getProject());
                String[] text = new String[]{String.format("The module '%1$s' is an Android project without build variants, and cannot be built.", module.getName()), "Please fix the module's configuration in the build.gradle file and sync the project again."};
                messages.report(new SyncMessage("Project Structure Issues", MessageType.ERROR, text));
            }
            CheckAndroidModuleWithoutVariantsStep.cleanUpAndroidModuleWithoutVariants(module, context.getIdeModelsProvider());
            this.myShouldTerminateSetup = true;
        }
    }

    private static void cleanUpAndroidModuleWithoutVariants(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        Facets.removeAllFacets(ideModelsProvider.getModifiableFacetModel(module), AndroidFacet.ID);
        ModifiableRootModel rootModel = ideModelsProvider.getModifiableRootModel(module);
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            contentEntry.clearSourceFolders();
            contentEntry.clearExcludeFolders();
        }
    }
}

