/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea.java;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupIssues;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.java.JavaModuleDependenciesSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModuleSetupStep
extends JavaModuleSetupStep {
    private static final DependencyScope DEFAULT_DEPENDENCY_SCOPE = DependencyScope.COMPILE;
    @NotNull
    private final JavaModuleDependenciesSetup myDependenciesSetup;

    public DependenciesModuleSetupStep() {
        this(new JavaModuleDependenciesSetup());
    }

    @VisibleForTesting
    DependenciesModuleSetupStep(@NotNull JavaModuleDependenciesSetup dependenciesSetup) {
        this.myDependenciesSetup = dependenciesSetup;
    }

    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull JavaModuleModel javaModuleModel) {
        Module module = context.getModule();
        IdeModifiableModelsProvider ideModelsProvider = context.getIdeModelsProvider();
        ArrayList<String> unresolved = new ArrayList<String>();
        for (JavaModuleDependency javaModuleDependency : javaModuleModel.getJavaModuleDependencies()) {
            DependenciesModuleSetupStep.updateDependency(context, javaModuleDependency);
        }
        for (JarLibraryDependency jarLibraryDependency : javaModuleModel.getJarLibraryDependencies()) {
            if (jarLibraryDependency.isResolved()) {
                this.updateDependency(module, ideModelsProvider, jarLibraryDependency);
                continue;
            }
            unresolved.add(jarLibraryDependency.getName());
        }
        UnresolvedDependenciesReporter.getInstance().report(unresolved, module);
    }

    private static void updateDependency(@NotNull ModuleSetupContext context, @NotNull JavaModuleDependency dependency) {
        Module module = context.getModule();
        IdeModifiableModelsProvider modelsProvider = context.getIdeModelsProvider();
        DependencySetupIssues setupIssues = DependencySetupIssues.getInstance(module.getProject());
        String moduleName = dependency.getModuleName();
        ModuleFinder moduleFinder = context.getModuleFinder();
        assert (moduleFinder != null);
        Module found = moduleFinder.findModuleByModuleId(dependency.getModuleId());
        if (found == null) {
            found = modelsProvider.findIdeModule(moduleName);
        }
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        if (found != null) {
            if (DependenciesModuleSetupStep.isSelfDependencyByTest(dependency, module, found)) {
                return;
            }
            AndroidFacet androidFacet = Facets.findFacet(found, modelsProvider, AndroidFacet.ID);
            if (androidFacet == null) {
                ModuleOrderEntry entry = moduleModel.addModuleOrderEntry(found);
                entry.setExported(DependenciesModuleSetupStep.getExported());
            } else {
                setupIssues.addInvalidModuleDependency(moduleModel.getModule(), found.getName(), "Java modules cannot depend on Android modules");
            }
            return;
        }
        setupIssues.addMissingModule(moduleName, module.getName(), null);
    }

    static boolean isSelfDependencyByTest(@NotNull JavaModuleDependency dependency, @NotNull Module module, @Nullable Module dependencyModule) {
        return module.equals(dependencyModule) && StringUtil.compare((String)dependency.getScope(), (String)"TEST", (boolean)true) == 0;
    }

    private void updateDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull JarLibraryDependency dependency) {
        DependencyScope scope = DependenciesModuleSetupStep.parseScope(dependency.getScope());
        File binaryPath = dependency.getBinaryPath();
        if (binaryPath == null) {
            DependencySetupIssues setupIssues = DependencySetupIssues.getInstance(module.getProject());
            setupIssues.addMissingBinaryPath(module.getName());
            return;
        }
        String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
        this.myDependenciesSetup.setUpLibraryDependency(module, modelsProvider, name, scope, binaryPath, dependency.getSourcePath(), dependency.getJavadocPath(), DependenciesModuleSetupStep.getExported());
    }

    @VisibleForTesting
    static boolean getExported() {
        return true;
    }

    @NotNull
    private static DependencyScope parseScope(@Nullable String scope) {
        if (scope == null) {
            return DEFAULT_DEPENDENCY_SCOPE;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scope.equalsIgnoreCase(dependencyScope.toString())) continue;
            return dependencyScope;
        }
        return DEFAULT_DEPENDENCY_SCOPE;
    }

    @Override
    public boolean invokeOnSkippedSync() {
        return true;
    }
}

