/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea.java;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetupStep;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.LanguageLevel;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageLevelModuleSetupStep
extends JavaModuleSetupStep {
    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull JavaModuleModel javaModuleModel) {
        LanguageLevel languageLevel = javaModuleModel.getJavaLanguageLevel();
        if (languageLevel == null) {
            languageLevel = JavaLanguageLevelModuleSetupStep.getMinimumLanguageLevelForAndroidModules(context.getIdeModelsProvider());
        }
        if (languageLevel == null) {
            languageLevel = LanguageLevel.JDK_1_6;
        }
        ModifiableRootModel rootModel = context.getModifiableRootModel();
        LanguageLevelModuleExtensionImpl moduleExtension = (LanguageLevelModuleExtensionImpl)rootModel.getModuleExtension(LanguageLevelModuleExtensionImpl.class);
        moduleExtension.setLanguageLevel(languageLevel);
    }

    @Nullable
    private static LanguageLevel getMinimumLanguageLevelForAndroidModules(@NotNull IdeModifiableModelsProvider modelsProvider) {
        Module[] modules = modelsProvider.getModules();
        if (modules.length == 0) {
            return null;
        }
        LanguageLevel result2 = null;
        ArrayList<LanguageLevel> languageLevels = new ArrayList<LanguageLevel>();
        for (Module dependency : modules) {
            LanguageLevel dependencyLanguageLevel = JavaLanguageLevelModuleSetupStep.getLanguageLevelForAndroidModule(dependency, modelsProvider);
            if (dependencyLanguageLevel == null) continue;
            languageLevels.add(dependencyLanguageLevel);
        }
        for (LanguageLevel dependencyLanguageLevel : languageLevels) {
            if (result2 != null && result2.compareTo((Enum)dependencyLanguageLevel) <= 0) continue;
            result2 = dependencyLanguageLevel;
        }
        return result2;
    }

    @Nullable
    private static LanguageLevel getLanguageLevelForAndroidModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        AndroidModuleModel androidModel;
        AndroidFacet facet = Facets.findFacet(module, modelsProvider, AndroidFacet.ID);
        if (facet != null && (androidModel = AndroidModuleModel.get(facet)) != null) {
            return androidModel.getJavaLanguageLevel();
        }
        return null;
    }
}

