/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea.java;

import com.android.tools.idea.gradle.project.sync.setup.module.common.ModuleDependenciesSetup;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

class JavaModuleDependenciesSetup
extends ModuleDependenciesSetup {
    JavaModuleDependenciesSetup() {
    }

    void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull File binaryPath, @Nullable File sourcePath, @Nullable File documentationPath, boolean isExported) {
        String prefix = GradleConstants.SYSTEM_ID.getReadableName() + ": ";
        libraryName = libraryName.isEmpty() || StringUtil.startsWith((CharSequence)libraryName, (CharSequence)prefix) ? libraryName : prefix + libraryName;
        boolean newLibrary = false;
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library == null) {
            library = modelsProvider.createLibrary(libraryName);
            newLibrary = true;
        }
        if (newLibrary) {
            this.updateLibraryRootPath(library, OrderRootType.CLASSES, modelsProvider, binaryPath);
            this.updateLibraryRootPath(library, OrderRootType.SOURCES, modelsProvider, sourcePath);
            this.updateLibraryRootPath(library, JavadocOrderRootType.getInstance(), modelsProvider, documentationPath);
        }
        this.addLibraryAsDependency(library, libraryName, scope, module, modelsProvider, isExported);
    }

    private void updateLibraryRootPath(@NotNull Library library, @NotNull OrderRootType rootType, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable File path) {
        if (path != null) {
            this.updateLibraryRootTypePaths(library, rootType, modelsProvider, path);
        }
    }
}

