/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.ndk;

import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ContentEntriesSetup;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

class NdkContentEntriesSetup
extends ContentEntriesSetup {
    @NotNull
    private final NdkModuleModel myAndroidModel;

    NdkContentEntriesSetup(@NotNull NdkModuleModel ndkModuleModel, @NotNull ModifiableRootModel rootModel) {
        super(rootModel);
        this.myAndroidModel = ndkModuleModel;
    }

    @Override
    public void execute(@NotNull List<ContentEntry> contentEntries) {
        Collection<File> sourceFolders = this.myAndroidModel.getSelectedVariant().getSourceFolders();
        if (!sourceFolders.isEmpty()) {
            for (File path : sourceFolders) {
                this.addSourceFolder(path, contentEntries, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, false);
            }
        }
        this.addOrphans();
        this.excludeFromContentEntries(contentEntries, ".externalNativeBuild");
        this.excludeFromContentEntries(contentEntries, ".cxx");
    }

    private void excludeFromContentEntries(@NotNull List<ContentEntry> contentEntries, @NotNull String folderName) {
        File rootDirPath = this.myAndroidModel.getRootDirPath();
        File externalNativeBuildFolder = new File(rootDirPath, folderName);
        ContentEntry parentEntry = ContentEntries.findParentContentEntry(externalNativeBuildFolder, contentEntries.stream());
        if (parentEntry != null) {
            this.addExcludedFolder(parentEntry, externalNativeBuildFolder);
        }
    }
}

