/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.google.common.base.Strings;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class EnableDisableSingleVariantSyncStep {
    public static void setSingleVariantSyncState(@NotNull Project project) {
        EligibilityState state = EnableDisableSingleVariantSyncStep.isEligibleForSingleVariantSync(project);
        PropertiesComponent.getInstance((Project)project).setValue("not.eligible.for.single.variant.sync", !state.equals((Object)EligibilityState.ELIGIBLE));
    }

    @NotNull
    static EligibilityState isEligibleForSingleVariantSync(@NotNull Project project) {
        if (EnableDisableSingleVariantSyncStep.hasBuildSrcModule(project)) {
            return EligibilityState.BUILDSRC_MODULE;
        }
        boolean hasAndroidModule = false;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
                NdkModuleModel ndkModel;
                if ("Android".equals(facet.getName())) {
                    hasAndroidModule = true;
                    AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                    if (androidModel != null && !androidModel.getFeatures().isSingleVariantSyncSupported()) {
                        return EligibilityState.OLD_PLUGIN;
                    }
                }
                if (NdkFacet.getFacetName().equals(facet.getName()) && (ndkModel = NdkModuleModel.get(module)) != null && !ndkModel.getFeatures().isSingleVariantSyncSupported()) {
                    return EligibilityState.OLD_PLUGIN;
                }
                if (!"Kotlin".equals(facet.getName())) continue;
                return EligibilityState.KOTLIN;
            }
        }
        return hasAndroidModule ? EligibilityState.ELIGIBLE : EligibilityState.PURE_JAVA;
    }

    private static boolean hasBuildSrcModule(@NotNull Project project) {
        String projectPath = project.getBasePath();
        ArrayList<String> projectRoots = new ArrayList<String>();
        if (projectPath != null) {
            GradleProjectSettings.CompositeBuild compositeBuild;
            projectRoots.add(projectPath);
            GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectPath);
            if (projectSettings != null && (compositeBuild = projectSettings.getCompositeBuild()) != null) {
                for (BuildParticipant participant : compositeBuild.getCompositeParticipants()) {
                    projectRoots.add(Strings.nullToEmpty((String)participant.getRootPath()));
                }
            }
        }
        return projectRoots.stream().anyMatch(path -> SyncProjectModels.hasBuildSrcModule(path));
    }

    static enum EligibilityState {
        ELIGIBLE{

            @Override
            @NotNull
            String getReason() {
                return "";
            }
        }
        ,
        OLD_PLUGIN{

            @Override
            @NotNull
            String getReason() {
                return "use Android Gradle Plugin older than 3.3";
            }
        }
        ,
        PURE_JAVA{

            @Override
            @NotNull
            String getReason() {
                return "do not contain Android module";
            }
        }
        ,
        KOTLIN{

            @Override
            @NotNull
            String getReason() {
                return "use Kotlin";
            }
        }
        ,
        BUILDSRC_MODULE{

            @Override
            @NotNull
            String getReason() {
                return "contain buildSrc module";
            }
        };


        @NotNull
        abstract String getReason();
    }
}

