/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.ForcedPluginVersionUpgradeStep;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.RecommendedPluginVersionUpgradeStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class PluginVersionUpgrade {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ForcedPluginVersionUpgradeStep[] myForcedUpgradeSteps;
    @NotNull
    private final RecommendedPluginVersionUpgradeStep[] myRecommendedUpgradeSteps;

    @NotNull
    public static PluginVersionUpgrade getInstance(@NotNull Project project) {
        return (PluginVersionUpgrade)ServiceManager.getService((Project)project, PluginVersionUpgrade.class);
    }

    public PluginVersionUpgrade(@NotNull Project project) {
        this(project, ForcedPluginVersionUpgradeStep.getExtensions(), RecommendedPluginVersionUpgradeStep.getExtensions());
    }

    @VisibleForTesting
    public PluginVersionUpgrade(@NotNull Project project, @NotNull ForcedPluginVersionUpgradeStep[] forcedUpgradeSteps, @NotNull RecommendedPluginVersionUpgradeStep[] recommendedUpgradeSteps) {
        this.myProject = project;
        this.myForcedUpgradeSteps = forcedUpgradeSteps;
        this.myRecommendedUpgradeSteps = recommendedUpgradeSteps;
    }

    @Slow
    public boolean isForcedUpgradable() {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(this.myProject);
        if (pluginInfo == null) {
            return false;
        }
        return Arrays.stream(this.myForcedUpgradeSteps).anyMatch(it -> it.checkUpgradable(this.myProject, pluginInfo));
    }

    public boolean isRecommendedUpgradable() {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(this.myProject);
        if (pluginInfo == null) {
            return false;
        }
        return Arrays.stream(this.myRecommendedUpgradeSteps).anyMatch(it -> it.checkUpgradable(this.myProject, pluginInfo));
    }

    public boolean performForcedUpgrade() {
        return this.performUpgrade(this.myForcedUpgradeSteps);
    }

    public boolean performRecommendedUpgrade() {
        return this.performUpgrade(this.myRecommendedUpgradeSteps);
    }

    private boolean performUpgrade(@NotNull PluginVersionUpgradeStep[] steps) {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(this.myProject);
        if (pluginInfo == null) {
            PluginVersionUpgrade.getLog().warn("Unable to obtain application's Android Project");
            return false;
        }
        PluginVersionUpgrade.log(pluginInfo);
        return Arrays.stream(steps).anyMatch(it -> {
            if (it.checkUpgradable(this.myProject, pluginInfo)) {
                return it.performUpgradeAndSync(this.myProject, pluginInfo);
            }
            return false;
        });
    }

    @Slow
    public boolean checkAndPerformUpgrade() {
        if (this.performForcedUpgrade()) {
            return true;
        }
        return this.performRecommendedUpgrade();
    }

    private static void log(@NotNull AndroidPluginInfo pluginInfo) {
        GradleVersion current = pluginInfo.getPluginVersion();
        String recommended = LatestKnownPluginVersionProvider.INSTANCE.get();
        String message2 = String.format("Gradle model version: %1$s, recommended version for IDE: %2$s", current, recommended);
        PluginVersionUpgrade.getLog().info(message2);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(PluginVersionUpgrade.class);
    }
}

