/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.annotations.concurrency.Slow;
import com.android.builder.model.SyncIssue;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.RunConfigurationChecker;
import com.android.tools.idea.gradle.project.SupportedModuleChecker;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.build.output.AndroidGradleSyncTextConsoleView;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.compatibility.VersionCompatibilityChecker;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupIssues;
import com.android.tools.idea.gradle.project.sync.setup.post.EnableDisableSingleVariantSyncStep;
import com.android.tools.idea.gradle.project.sync.setup.post.MemorySettingsPostSyncChecker;
import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgrade;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedMemorySettingsCheckerReminder;
import com.android.tools.idea.gradle.project.sync.setup.post.project.DisposedModules;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.RecommendedPluginVersionUpgrade;
import com.android.tools.idea.gradle.project.sync.validation.common.CommonModuleValidator;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProvider;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.profiles.ProjectProfileSelectionDialog;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.concurrency.JobLauncher;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostSyncProjectSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final ProjectStructure myProjectStructure;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final DependencySetupIssues myDependencySetupIssues;
    @NotNull
    private final ProjectSetup myProjectSetup;
    @NotNull
    private final ModuleSetup myModuleSetup;
    @NotNull
    private final PluginVersionUpgrade myPluginVersionUpgrade;
    @NotNull
    private final VersionCompatibilityChecker myVersionCompatibilityChecker;
    @NotNull
    private final GradleProjectBuilder myProjectBuilder;
    @NotNull
    private final CommonModuleValidator.Factory myModuleValidatorFactory;
    @NotNull
    private final RunManagerEx myRunManager;

    @NotNull
    public static PostSyncProjectSetup getInstance(@NotNull Project project) {
        return (PostSyncProjectSetup)ServiceManager.getService((Project)project, PostSyncProjectSetup.class);
    }

    public PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull ProjectStructure projectStructure, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull GradleSyncMessages syncMessages, @NotNull DependencySetupIssues dependencySetupIssues, @NotNull PluginVersionUpgrade pluginVersionUpgrade, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder) {
        this(project, ideInfo, projectStructure, gradleProjectInfo, syncInvoker, syncState, dependencySetupIssues, new ProjectSetup(project), new ModuleSetup(project), pluginVersionUpgrade, versionCompatibilityChecker, projectBuilder, new CommonModuleValidator.Factory(), RunManagerEx.getInstanceEx((Project)project));
    }

    @VisibleForTesting
    PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull ProjectStructure projectStructure, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull DependencySetupIssues dependencySetupIssues, @NotNull ProjectSetup projectSetup, @NotNull ModuleSetup moduleSetup, @NotNull PluginVersionUpgrade pluginVersionUpgrade, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder, @NotNull CommonModuleValidator.Factory moduleValidatorFactory, @NotNull RunManagerEx runManager) {
        this.myProject = project;
        this.myIdeInfo = ideInfo;
        this.myProjectStructure = projectStructure;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.mySyncInvoker = syncInvoker;
        this.mySyncState = syncState;
        this.myDependencySetupIssues = dependencySetupIssues;
        this.myProjectSetup = projectSetup;
        this.myModuleSetup = moduleSetup;
        this.myPluginVersionUpgrade = pluginVersionUpgrade;
        this.myVersionCompatibilityChecker = versionCompatibilityChecker;
        this.myProjectBuilder = projectBuilder;
        this.myModuleValidatorFactory = moduleValidatorFactory;
        this.myRunManager = runManager;
    }

    @Slow
    public void setUpProject(@NotNull Request request, @NotNull ProgressIndicator progressIndicator, @Nullable ExternalSystemTaskId taskId) {
        try {
            if (!((Boolean)StudioFlags.NEW_SYNC_INFRA_ENABLED.get()).booleanValue()) {
                ModuleSetupContext.removeSyncContextDataFrom(this.myProject);
            }
            this.myGradleProjectInfo.setNewProject(false);
            this.myGradleProjectInfo.setImportedProject(false);
            boolean syncFailed = this.mySyncState.lastSyncFailedOrHasIssues();
            if (syncFailed && request.usingCachedGradleModels) {
                this.onCachedModelsSetupFailure(request);
                return;
            }
            this.myDependencySetupIssues.reportIssues();
            this.myVersionCompatibilityChecker.checkAndReportComponentIncompatibilities(this.myProject);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            List<Module> modules = Arrays.asList(moduleManager.getModules());
            CommonModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(modules, progressIndicator, module -> {
                moduleValidator.validate((Module)module);
                return true;
            });
            moduleValidator.fixAndReportFoundIssues();
            if (syncFailed) {
                this.failTestsIfSyncIssuesPresent();
                this.myProjectSetup.setUpProject(progressIndicator, true);
                this.mySyncState.syncFailed("");
                PostSyncProjectSetup.finishFailedSync(taskId, this.myProject);
                return;
            }
            boolean skipAgpUpgrade = SystemProperties.getBooleanProperty((String)"studio.skip.agp.upgrade", (boolean)false);
            if (!skipAgpUpgrade && !request.skipAndroidPluginUpgrade) {
                if (((Boolean)StudioFlags.BALLOON_UPGRADE_NOTIFICATION.get()).booleanValue()) {
                    if (this.myPluginVersionUpgrade.isForcedUpgradable()) {
                        if (this.myPluginVersionUpgrade.performForcedUpgrade()) {
                            this.finishSuccessfulSync(taskId);
                            return;
                        }
                    } else {
                        RecommendedPluginVersionUpgrade.checkUpgrade(this.myProject);
                    }
                } else if (this.myPluginVersionUpgrade.checkAndPerformUpgrade()) {
                    this.finishSuccessfulSync(taskId);
                    return;
                }
            }
            if (((Boolean)StudioFlags.RECOMMENDATION_ENABLED.get()).booleanValue()) {
                MemorySettingsPostSyncChecker.checkSettings(this.myProject, new TimeBasedMemorySettingsCheckerReminder());
            }
            new ProjectStructureUsageTracker(this.myProject).trackProjectStructure();
            DisposedModules.getInstance(this.myProject).deleteImlFilesForDisposedModules();
            SupportedModuleChecker.getInstance().checkForSupportedModules(this.myProject);
            this.findAndShowVariantConflicts();
            this.myProjectSetup.setUpProject(progressIndicator, false);
            this.modifyJUnitRunConfigurations();
            RunConfigurationChecker.getInstance(this.myProject).ensureRunConfigsInvokeBuild();
            ProjectStructure.AndroidPluginVersionsInProject agpVersions = this.myProjectStructure.getAndroidPluginVersions();
            this.myProjectStructure.analyzeProjectStructure(progressIndicator);
            boolean cleanProjectAfterSync = this.myProjectStructure.getAndroidPluginVersions().haveVersionsChanged(agpVersions);
            this.attemptToGenerateSources(request, cleanProjectAfterSync);
            this.updateJavaLanguageLevel();
            this.notifySyncFinished(request);
            TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
            this.myModuleSetup.setUpModules(null);
            this.finishSuccessfulSync(taskId);
            EnableDisableSingleVariantSyncStep.setSingleVariantSyncState(this.myProject);
        }
        catch (Throwable t) {
            this.mySyncState.syncFailed("setup project failed: " + t.getMessage());
            PostSyncProjectSetup.finishFailedSync(taskId, this.myProject);
            this.getLog().error(t);
        }
    }

    @VisibleForTesting
    void updateJavaLanguageLevel() {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

            public void execute() {
                LanguageLevelProjectExtension ext;
                LanguageLevel langLevel;
                if (PostSyncProjectSetup.this.myProject.isOpen() && (langLevel = PostSyncProjectSetup.getMaxJavaLanguageLevel(PostSyncProjectSetup.this.myProject)) != null && langLevel != (ext = LanguageLevelProjectExtension.getInstance((Project)PostSyncProjectSetup.this.myProject)).getLanguageLevel()) {
                    ext.setLanguageLevel(langLevel);
                }
            }
        });
    }

    @VisibleForTesting
    @Nullable
    static LanguageLevel getMaxJavaLanguageLevel(@NotNull Project project) {
        Module[] modules;
        LanguageLevel maxLangLevel = null;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            LanguageLevel langLevel;
            AndroidModuleModel androidModel;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || (androidModel = AndroidModuleModel.get(facet)) == null || (langLevel = androidModel.getJavaLanguageLevel()) == null || maxLangLevel != null && maxLangLevel.compareTo((Enum)langLevel) >= 0) continue;
            maxLangLevel = langLevel;
        }
        return maxLangLevel;
    }

    private void finishSuccessfulSync(@Nullable ExternalSystemTaskId taskId) {
        if (taskId == null) {
            return;
        }
        String message2 = "synced successfully";
        GradleSyncMessages messages = GradleSyncMessages.getInstance(this.myProject);
        List<Failure> failures = messages.showEvents(taskId);
        Object result2 = failures.isEmpty() ? new SuccessResultImpl() : new FailureResultImpl(failures);
        FinishBuildEventImpl finishBuildEvent = new FinishBuildEventImpl((Object)taskId, null, System.currentTimeMillis(), message2, (EventResult)result2);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myProject.isDisposed()) {
                ((SyncViewManager)ServiceManager.getService((Project)this.myProject, SyncViewManager.class)).onEvent((BuildEvent)finishBuildEvent);
            }
        });
    }

    public static void finishFailedSync(@Nullable ExternalSystemTaskId taskId, @NotNull Project project) {
        if (taskId != null) {
            String message2 = "sync failed";
            GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
            List<Failure> failures = messages.showEvents(taskId);
            FailureResultImpl failureResult = new FailureResultImpl(failures);
            FinishBuildEventImpl finishBuildEvent = new FinishBuildEventImpl((Object)taskId, null, System.currentTimeMillis(), message2, (EventResult)failureResult);
            ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent((BuildEvent)finishBuildEvent);
        }
    }

    public void onCachedModelsSetupFailure(@NotNull Request request) {
        long syncTimestamp = request.lastSyncTimestamp;
        if (syncTimestamp < 0L) {
            syncTimestamp = System.currentTimeMillis();
        }
        this.mySyncState.syncSkipped(syncTimestamp);
        this.mySyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_CACHED_SETUP_FAILED);
    }

    private void failTestsIfSyncIssuesPresent() {
        if (ApplicationManager.getApplication().isUnitTestMode() && this.mySyncState.getSummary().hasSyncErrors()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Sync issues found!").append('\n');
            this.myGradleProjectInfo.forEachAndroidModule((Consumer<AndroidFacet>)((Consumer)facet -> {
                Collection<SyncIssue> issues;
                AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
                if (androidModel instanceof AndroidModuleModel && (issues = ((AndroidModuleModel)androidModel).getSyncIssues()) != null && !issues.isEmpty()) {
                    buffer.append("Module '").append(facet.getModule().getName()).append("':").append('\n');
                    for (SyncIssue issue2 : issues) {
                        buffer.append(issue2.getMessage()).append('\n');
                    }
                }
            }));
            throw new IllegalStateException(buffer.toString());
        }
    }

    private void notifySyncFinished(@NotNull Request request) {
        if (request.usingCachedGradleModels) {
            long timestamp = System.currentTimeMillis();
            this.mySyncState.syncSkipped(timestamp);
            GradleBuildState.getInstance(this.myProject).buildFinished(BuildStatus.SKIPPED);
        } else {
            if (this.mySyncState.lastSyncFailedOrHasIssues()) {
                this.mySyncState.syncFailed("");
            } else {
                this.mySyncState.syncEnded();
            }
            ProjectBuildFileChecksums.saveToDisk(this.myProject);
        }
    }

    private void findAndShowVariantConflicts() {
        ConflictSet conflicts = ConflictSet.findConflicts(this.myProject);
        List<Conflict> structureConflicts = conflicts.getStructureConflicts();
        if (!structureConflicts.isEmpty() && SystemProperties.getBooleanProperty((String)"enable.project.profiles", (boolean)false)) {
            ProjectProfileSelectionDialog dialog2 = new ProjectProfileSelectionDialog(this.myProject, structureConflicts);
            dialog2.show();
        }
        conflicts.showSelectionConflicts();
    }

    private void modifyJUnitRunConfigurations() {
        AndroidJUnitConfigurationType junitConfigurationType = AndroidJUnitConfigurationType.getInstance();
        BeforeRunTaskProvider[] taskProviders = (BeforeRunTaskProvider[])BeforeRunTaskProvider.EXTENSION_POINT_NAME.getExtensions((AreaInstance)this.myProject);
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        Key makeTaskId = this.myIdeInfo.isAndroidStudio() ? MakeBeforeRunTaskProvider.ID : CompileStepBeforeRun.ID;
        BeforeRunTaskProvider targetProvider = null;
        for (BeforeRunTaskProvider provider : taskProviders) {
            if (!makeTaskId.equals((Object)provider.getId())) continue;
            targetProvider = provider;
            break;
        }
        if (targetProvider != null) {
            HashMap currentTasks = new HashMap();
            for (RunConfiguration runConfiguration : this.myRunManager.getConfigurationsList((ConfigurationType)junitConfigurationType)) {
                currentTasks.put(runConfiguration, new ArrayList(runManager.getBeforeRunTasks(runConfiguration)));
            }
            for (ConfigurationFactory configurationFactory : junitConfigurationType.getConfigurationFactories()) {
                RunnerAndConfigurationSettings template = this.myRunManager.getConfigurationTemplate(configurationFactory);
                AndroidJUnitConfiguration runConfiguration = (AndroidJUnitConfiguration)template.getConfiguration();
                this.setMakeStepInJUnitConfiguration(targetProvider, (RunConfiguration)runConfiguration);
                runConfiguration.setWorkingDirectory("$MODULE_DIR$");
            }
            for (RunConfiguration runConfiguration : this.myRunManager.getConfigurationsList((ConfigurationType)junitConfigurationType)) {
                runManager.setBeforeRunTasks(runConfiguration, (List)currentTasks.get(runConfiguration), false);
            }
        }
    }

    private void setMakeStepInJUnitConfiguration(@NotNull BeforeRunTaskProvider targetProvider, @NotNull RunConfiguration runConfiguration) {
        LinkedList<BeforeRunTask> newBeforeRunTasks = new LinkedList<BeforeRunTask>();
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        for (BeforeRunTask beforeRunTask : runManager.getBeforeRunTasks(runConfiguration)) {
            if (beforeRunTask.getProviderId().equals((Object)CompileStepBeforeRun.ID)) {
                BeforeRunTask task;
                if (!runManager.getBeforeRunTasks(runConfiguration, MakeBeforeRunTaskProvider.ID).isEmpty() || (task = targetProvider.createTask(runConfiguration)) == null) continue;
                task.setEnabled(true);
                newBeforeRunTasks.add(task);
                continue;
            }
            newBeforeRunTasks.add(beforeRunTask);
        }
        runManager.setBeforeRunTasks(runConfiguration, newBeforeRunTasks);
    }

    private void attemptToGenerateSources(@NotNull Request request, boolean cleanProjectAfterSync) {
        if (!request.generateSourcesAfterSync) {
            return;
        }
        if (cleanProjectAfterSync) {
            this.myProjectBuilder.cleanAndGenerateSources();
            return;
        }
        this.myProjectBuilder.generateSources();
    }

    @NotNull
    private Logger getLog() {
        return Logger.getInstance(this.getClass());
    }

    @NotNull
    public static ExternalSystemTaskId createProjectSetupFromCacheTaskWithStartMessage(Project project) {
        ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project);
        String workingDir = FileUtil.toCanonicalPath((String)Projects.getBaseDirPath((Project)project).getPath());
        DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)taskId, "Project setup", workingDir, System.currentTimeMillis());
        SyncViewManager syncManager = (SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class);
        syncManager.onEvent((BuildEvent)new StartBuildEventImpl((BuildDescriptor)buildDescriptor, "reading from cache...").withContentDescriptorSupplier(() -> {
            AndroidGradleSyncTextConsoleView consoleView = new AndroidGradleSyncTextConsoleView(project);
            return new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleView.getComponent(), "Gradle Sync");
        }));
        return taskId;
    }

    public static class Request {
        public boolean usingCachedGradleModels;
        public boolean cleanProjectAfterSync;
        public boolean generateSourcesAfterSync = true;
        public boolean skipAndroidPluginUpgrade;
        public long lastSyncTimestamp = -1L;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.usingCachedGradleModels == request.usingCachedGradleModels && this.cleanProjectAfterSync == request.cleanProjectAfterSync && this.generateSourcesAfterSync == request.generateSourcesAfterSync && this.lastSyncTimestamp == request.lastSyncTimestamp;
        }

        public int hashCode() {
            return Objects.hash(this.usingCachedGradleModels, this.cleanProjectAfterSync, this.generateSourcesAfterSync, this.lastSyncTimestamp);
        }
    }
}

