/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCleanup {
    @NotNull
    private final ProjectCleanupStep[] myCleanupSteps;

    public ProjectCleanup() {
        this(ProjectCleanupStep.getExtensions());
    }

    @VisibleForTesting
    ProjectCleanup(ProjectCleanupStep ... cleanupSteps) {
        this.myCleanupSteps = cleanupSteps;
    }

    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModelsProvider, @Nullable ProgressIndicator indicator) {
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        if (syncState.lastSyncFailedOrHasIssues()) {
            return;
        }
        boolean syncSkipped = syncState.isSyncSkipped();
        for (ProjectCleanupStep step : this.myCleanupSteps) {
            if (syncSkipped && !step.invokeOnSkippedSync()) continue;
            step.cleanUpProject(project, ideModelsProvider, indicator);
        }
    }
}

