/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeBasedMemorySettingsCheckerReminder {
    private static final String MEMORY_SETTINGS_DO_NOT_ASK_FOR_ALL_PROPERTY = "memory.settings.postsync.do.not.show.again";
    private static final String MEMORY_SETTINGS_DO_NOT_ASK_FOR_PROJECT_PROPERTY = "memory.settings.postsync.do.not.ask.for.project";
    private static final String MEMORY_SETTINGS_POST_SYNC_CHECK_TIMESTAMP_PROPERTY = "memory.settings.last.check.timestamp";

    boolean shouldCheck(@NotNull Project project) {
        return this.shouldCheck(project, System.currentTimeMillis());
    }

    boolean shouldCheck(@NotNull Project project, long currentTimeInMs) {
        if (this.shouldNotAsk(project)) {
            return false;
        }
        String lastTimestampValue = this.getStoredTimestamp();
        if (StringUtil.isNotEmpty((String)lastTimestampValue)) {
            try {
                long lastTimestamp = Long.parseLong(lastTimestampValue);
                long elapsed = currentTimeInMs - lastTimestamp;
                long days = TimeUnit.MILLISECONDS.toDays(elapsed);
                return days >= 1L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    @Nullable
    String getStoredTimestamp() {
        return PropertiesComponent.getInstance().getValue(MEMORY_SETTINGS_POST_SYNC_CHECK_TIMESTAMP_PROPERTY);
    }

    void storeLastCheckTimestamp() {
        this.storeLastCheckTimestamp(System.currentTimeMillis());
    }

    void storeLastCheckTimestamp(long currentTimeInMs) {
        PropertiesComponent.getInstance().setValue(MEMORY_SETTINGS_POST_SYNC_CHECK_TIMESTAMP_PROPERTY, String.valueOf(currentTimeInMs));
    }

    void setDoNotAsk(@NotNull Project project) {
        PropertiesComponent.getInstance((Project)project).setValue(MEMORY_SETTINGS_DO_NOT_ASK_FOR_PROJECT_PROPERTY, "true");
    }

    void setDoNotAskForApplication() {
        PropertiesComponent.getInstance().setValue(MEMORY_SETTINGS_DO_NOT_ASK_FOR_ALL_PROPERTY, "true");
    }

    private boolean shouldNotAsk(@NotNull Project project) {
        return PropertiesComponent.getInstance().getValue(MEMORY_SETTINGS_DO_NOT_ASK_FOR_ALL_PROPERTY, "false").equals("true") || PropertiesComponent.getInstance((Project)project).getValue(MEMORY_SETTINGS_DO_NOT_ASK_FOR_PROJECT_PROPERTY, "false").equals("true");
    }
}

