/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.project.AndroidNotification;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Calendar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpiredPreviewBuildSetupStep
extends ProjectSetupStep {
    @NotNull
    private final ApplicationInfo myApplicationInfo;
    private volatile boolean myExpirationChecked;

    public ExpiredPreviewBuildSetupStep() {
        this(ApplicationInfo.getInstance());
    }

    public ExpiredPreviewBuildSetupStep(@NotNull ApplicationInfo applicationInfo) {
        this.myApplicationInfo = applicationInfo;
    }

    @Override
    public void setUpProject(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (this.myExpirationChecked) {
            return;
        }
        String ideVersion = this.myApplicationInfo.getFullVersion();
        if (ExpiredPreviewBuildSetupStep.isPreview(ideVersion)) {
            Calendar expirationDate = (Calendar)this.myApplicationInfo.getBuildDate().clone();
            expirationDate.add(2, 2);
            Calendar now = Calendar.getInstance();
            if (now.after(expirationDate)) {
                String message2 = String.format("This preview build (%1$s) is old; please update to a newer preview or a stable version.", ideVersion);
                OpenUrlHyperlink hyperlink = new OpenUrlHyperlink("https://developer.android.com/r/studio-ui/download-canary.html", "Get the Latest Version");
                AndroidNotification.getInstance(project).showBalloon("Old Preview Build", message2, NotificationType.INFORMATION, hyperlink);
                this.myExpirationChecked = true;
            }
        }
    }

    private static boolean isPreview(@NotNull String ideVersion) {
        return ideVersion.contains("Preview") || ideVersion.contains("Beta") || ideVersion.contains("RC");
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }

    @VisibleForTesting
    boolean isExpirationChecked() {
        return this.myExpirationChecked;
    }
}

