/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.annotations.concurrency.Slow;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkToolsVersionSetupStep
extends ProjectSetupStep {
    private static final ProgressIndicator REPO_LOGGER = new StudioLoggerProgressIndicator(SdkToolsVersionSetupStep.class);
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final Supplier<? extends RepoManager> myRepoManagerSupplier;
    @NotNull
    private final Supplier<? extends ExecutorService> myExecutorServiceSupplier;
    private volatile boolean myNewSdkVersionToolsInfoAlreadyShown;
    private volatile boolean myNewSdkVersionToolsInfoCheckInProgress;
    private static final Supplier<RepoManager> REPO_MANAGER_SUPPLIER = () -> {
        AndroidSdkData data = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (data == null) {
            return null;
        }
        RepoManager mgr = data.getSdkHandler().getSdkManager(REPO_LOGGER);
        if (mgr.getLocalPath() == null) {
            return null;
        }
        return mgr;
    };

    public SdkToolsVersionSetupStep() {
        this(IdeSdks.getInstance(), REPO_MANAGER_SUPPLIER, () -> ApplicationManager.getApplication().isUnitTestMode() ? MoreExecutors.newDirectExecutorService() : AppExecutorUtil.getAppExecutorService());
    }

    @VisibleForTesting
    SdkToolsVersionSetupStep(@NotNull IdeSdks ideSdks, @NotNull Supplier<? extends RepoManager> repoManagerSupplier, Supplier<? extends ExecutorService> executorServiceSupplier) {
        this.myIdeSdks = ideSdks;
        this.myRepoManagerSupplier = repoManagerSupplier;
        this.myExecutorServiceSupplier = executorServiceSupplier;
    }

    @Override
    public void setUpProject(@NotNull Project project, @Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        if (this.myNewSdkVersionToolsInfoAlreadyShown || this.myNewSdkVersionToolsInfoCheckInProgress) {
            return;
        }
        File androidHome = this.myIdeSdks.getAndroidSdkPath();
        if (androidHome != null) {
            this.myNewSdkVersionToolsInfoCheckInProgress = true;
            this.myExecutorServiceSupplier.get().submit(() -> {
                if (!this.checkToolsPackage(project, androidHome)) {
                    InstallSdkToolsHyperlink hyperlink = new InstallSdkToolsHyperlink(VersionCheck.MIN_TOOLS_REV);
                    String message2 = "Version " + VersionCheck.MIN_TOOLS_REV + " or later is required.";
                    AndroidNotification.getInstance(project).showBalloon("Android SDK Tools", message2, NotificationType.INFORMATION, hyperlink);
                    this.myNewSdkVersionToolsInfoAlreadyShown = true;
                }
                this.myNewSdkVersionToolsInfoCheckInProgress = false;
            });
        }
    }

    @Slow
    private boolean checkToolsPackage(@NotNull Project project, @NotNull File androidHome) {
        return VersionCheck.isCompatibleVersion(androidHome) || this.checkToolsPackageUsingRepoManager(project);
    }

    private boolean checkToolsPackageUsingRepoManager(@NotNull Project project) {
        RepoManager mgr = this.myRepoManagerSupplier.get();
        if (mgr == null) {
            return false;
        }
        mgr.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, null, null, (ProgressRunner)new StudioProgressRunner(true, false, "Finding Available SDK Components", project), null, StudioSettingsController.getInstance(), true);
        return mgr.getPackages().getLocalPackages().containsKey("tools");
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }

    @VisibleForTesting
    boolean isNewSdkVersionToolsInfoAlreadyShown() {
        return this.myNewSdkVersionToolsInfoAlreadyShown;
    }

    @VisibleForTesting
    public static class InstallSdkToolsHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Revision myVersion;

        InstallSdkToolsHyperlink(@NotNull Revision version2) {
            super("install.sdk.tools", "Install latest SDK Tools");
            this.myVersion = version2;
        }

        @Override
        protected void execute(@NotNull Project project) {
            ArrayList requested = Lists.newArrayList();
            if (this.myVersion.getMajor() == 23) {
                Revision minBuildToolsRev = new Revision(20, 0, 0);
                requested.add(DetailsTypes.getBuildToolsPath((Revision)minBuildToolsRev));
            }
            requested.add("tools");
            ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, requested);
            if (dialog2 != null && dialog2.showAndGet()) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_QF_SDK_VERSION_INSTALLED);
            }
        }

        @VisibleForTesting
        @NotNull
        Revision getVersion() {
            return this.myVersion;
        }
    }
}

