/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.UpgradeDialogMetricUtilsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradlePluginUpgradeDialogStats;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TestDialog;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedPluginPreviewVersionUpgradeDialog
extends DialogWrapper {
    private JPanel myCenterPanel;
    private JEditorPane myMessagePane;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myMessage;
    @NotNull
    private final String myRecommendedPluginVersion;
    @Nullable
    private final String myCurrentPluginVersion;
    private static TestDialog ourTestImplementation = TestDialog.DEFAULT;

    public static TestDialog setTestDialog(@NotNull TestDialog newValue) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            ForcedPluginPreviewVersionUpgradeDialog.getLog().assertTrue(application.isUnitTestMode(), (Object)"This method is available for tests only");
        }
        TestDialog oldValue = ourTestImplementation;
        ourTestImplementation = newValue;
        return oldValue;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(ForcedPluginPreviewVersionUpgradeDialog.class);
    }

    public ForcedPluginPreviewVersionUpgradeDialog(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        super(project);
        String pluginVersion;
        this.myProject = project;
        this.$$$setupUI$$$();
        boolean experimental = pluginInfo.isExperimental();
        String pluginType = experimental ? "Experimental " : "";
        this.setTitle("Android Gradle " + pluginType + "Plugin Update Required");
        this.init();
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myMessagePane);
        this.myRecommendedPluginVersion = pluginVersion = pluginInfo.getLatestKnownPluginVersionProvider().get();
        GradleVersion currentVersion = pluginInfo.getPluginVersion();
        this.myCurrentPluginVersion = currentVersion != null ? pluginInfo.getPluginVersion().toString() : null;
        this.myMessage = "<b>The project is using an incompatible version of the Android Gradle plugin.</b><br/<br/>To continue opening the project, the IDE will update the plugin to version " + pluginVersion + ".<br/><br/>You can learn more about this version of the plugin from the <a href='https://developer.android.com/studio/" + (experimental ? "build/experimental-plugin.html" : "releases/gradle-plugin.html") + "'>release notes</a>.<br/><br/>";
        this.myMessagePane.setText(this.myMessage);
        this.myMessagePane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
    }

    @VisibleForTesting
    @NotNull
    String getDisplayedMessage() {
        return this.myMessage;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    public void doCancelAction() {
        UpgradeDialogMetricUtilsKt.recordUpgradeDialogEvent(this.myProject, this.myCurrentPluginVersion, this.myRecommendedPluginVersion, GradlePluginUpgradeDialogStats.UserAction.CANCEL);
        super.doCancelAction();
    }

    protected void doOKAction() {
        UpgradeDialogMetricUtilsKt.recordUpgradeDialogEvent(this.myProject, this.myCurrentPluginVersion, this.myRecommendedPluginVersion, GradlePluginUpgradeDialogStats.UserAction.OK);
        super.doOKAction();
    }

    @NotNull
    protected Action getOKAction() {
        Action action2 = super.getOKAction();
        action2.putValue("Name", "Update");
        return action2;
    }

    @NotNull
    protected Action getCancelAction() {
        Action action2 = super.getCancelAction();
        action2.putValue("Name", "Cancel and update manually");
        return action2;
    }

    public boolean showAndGet() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            int result2 = ourTestImplementation.show(this.myMessage);
            Disposer.dispose((Disposable)this.getDisposable());
            return result2 == 0;
        }
        return super.showAndGet();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        this.myCenterPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMessagePane = jEditorPane = new JEditorPane();
        jPanel.add((Component)jEditorPane, new GridConstraints(0, 0, 1, 1, 1, 1, 6, 6, null, new Dimension(470, 130), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myCenterPanel;
    }
}

