/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.ForcedPluginPreviewVersionUpgradeDialog;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedPluginVersionUpgradeStep
implements PluginVersionUpgradeStep {
    public static final ExtensionPointName<ForcedPluginVersionUpgradeStep> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.android.gradle.sync.forcedPluginVersionUpgradeStep");

    @NotNull
    public static ForcedPluginVersionUpgradeStep[] getExtensions() {
        return (ForcedPluginVersionUpgradeStep[])EXTENSION_POINT_NAME.getExtensions();
    }

    @Override
    @Slow
    public boolean checkUpgradable(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        GradleVersion recommended = GradleVersion.parse((String)pluginInfo.getLatestKnownPluginVersionProvider().get());
        return ForcedPluginVersionUpgradeStep.shouldPreviewBeForcedToUpgradePluginVersion(recommended, pluginInfo.getPluginVersion());
    }

    @Override
    @Slow
    public boolean performUpgradeAndSync(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        if (!this.checkUpgradable(project, pluginInfo)) {
            return false;
        }
        LatestKnownPluginVersionProvider latestKnownPluginVersionProvider = pluginInfo.getLatestKnownPluginVersionProvider();
        GradleVersion recommended = GradleVersion.parse((String)latestKnownPluginVersionProvider.get());
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        syncState.syncEnded();
        Ref result2 = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set((Object)new ForcedPluginPreviewVersionUpgradeDialog(project, pluginInfo).showAndGet()), ModalityState.NON_MODAL);
        boolean userAcceptsForcedUpgrade = (Boolean)result2.get();
        if (userAcceptsForcedUpgrade) {
            AndroidPluginVersionUpdater versionUpdater = AndroidPluginVersionUpdater.getInstance(project);
            versionUpdater.updatePluginVersionAndSync(recommended, GradleVersion.parse((String)"5.4.1"), true);
        } else {
            String[] text = new String[]{"The project is using an incompatible version of the Android Gradle plugin.", "Please update your project to use version " + latestKnownPluginVersionProvider.get() + "."};
            SyncMessage msg = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, text);
            String pluginName = "com.android.tools.build:gradle";
            SearchInBuildFilesHyperlink quickFix = new SearchInBuildFilesHyperlink(pluginName);
            msg.add(quickFix);
            GradleSyncMessages.getInstance(project).report(msg);
            syncState.invalidateLastSync("Force plugin upgrade declined");
        }
        return true;
    }

    @VisibleForTesting
    static boolean shouldPreviewBeForcedToUpgradePluginVersion(@NotNull GradleVersion recommended, @Nullable GradleVersion current) {
        if (current != null && current.getPreviewType() != null) {
            if (recommended.isSnapshot() && current.compareIgnoringQualifiers(recommended) == 0) {
                return false;
            }
            if (recommended.isAtLeast(2, 4, 0, "alpha", 8, false)) {
                if (current.compareTo(recommended) >= 0) {
                    return false;
                }
                if (current.getPreviewType().equals("rc") && recommended.getPreviewType() != null && current.getMajor() == recommended.getMajor() && current.getMinor() == recommended.getMinor() - 1) {
                    return false;
                }
                boolean isOlderPreviewAllowed = current.isPreview() && current.getMajor() == 2 && current.getMinor() == 4 && current.compareTo(recommended) < 0;
                return !isOlderPreviewAllowed;
            }
            return current.compareTo(recommended) < 0;
        }
        return false;
    }
}

