/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.RecommendedPluginVersionUpgradeDialog;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.TimeBasedUpgradeReminder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecommendedPluginVersionUpgradeStep
implements PluginVersionUpgradeStep {
    public static final ExtensionPointName<RecommendedPluginVersionUpgradeStep> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.android.gradle.sync.recommendedPluginVersionUpgradeStep");
    @NotNull
    private final RecommendedPluginVersionUpgradeDialog.Factory myUpgradeDialogFactory;
    @NotNull
    private final TimeBasedUpgradeReminder myUpgradeReminder;

    @NotNull
    public static RecommendedPluginVersionUpgradeStep[] getExtensions() {
        return (RecommendedPluginVersionUpgradeStep[])EXTENSION_POINT_NAME.getExtensions();
    }

    public RecommendedPluginVersionUpgradeStep() {
        this(new RecommendedPluginVersionUpgradeDialog.Factory(), new TimeBasedUpgradeReminder());
    }

    @VisibleForTesting
    RecommendedPluginVersionUpgradeStep(@NotNull RecommendedPluginVersionUpgradeDialog.Factory upgradeDialogFactory, @NotNull TimeBasedUpgradeReminder upgradeReminder) {
        this.myUpgradeDialogFactory = upgradeDialogFactory;
        this.myUpgradeReminder = upgradeReminder;
    }

    @Override
    @Slow
    public boolean checkUpgradable(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        if (this.myUpgradeReminder.shouldRecommendUpgrade(project) && RecommendedPluginVersionUpgradeStep.shouldRecommendUpgrade(pluginInfo)) {
            GradleVersion current = pluginInfo.getPluginVersion();
            assert (current != null);
            GradleVersion recommended = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
            AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(project);
            if (updater.canDetectPluginVersionToUpdate(recommended)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Slow
    public boolean performUpgradeAndSync(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        if (!this.checkUpgradable(project, pluginInfo)) {
            return false;
        }
        GradleVersion current = pluginInfo.getPluginVersion();
        assert (current != null);
        GradleVersion recommended = GradleVersion.parse((String)pluginInfo.getLatestKnownPluginVersionProvider().get());
        AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(project);
        if (updater.canDetectPluginVersionToUpdate(recommended)) {
            GradleVersion latestGradleVersion;
            AndroidPluginVersionUpdater.UpdateResult result2;
            boolean userAcceptsUpgrade;
            Computable promptUserTask = () -> {
                RecommendedPluginVersionUpgradeDialog updateDialog = this.myUpgradeDialogFactory.create(project, current, recommended);
                return updateDialog.showAndGet();
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                userAcceptsUpgrade = (Boolean)promptUserTask.compute();
            } else {
                Ref result3 = Ref.create();
                ApplicationManager.getApplication().invokeAndWait(() -> result3.set(promptUserTask.compute()), ModalityState.NON_MODAL);
                userAcceptsUpgrade = (Boolean)result3.get();
            }
            if (userAcceptsUpgrade && (result2 = updater.updatePluginVersionAndSync(recommended, latestGradleVersion = GradleVersion.parse((String)"5.4.1"), false)).versionUpdateSuccess()) {
                return true;
            }
        }
        return false;
    }

    private static boolean shouldRecommendUpgrade(@NotNull AndroidPluginInfo androidPluginInfo) {
        GradleVersion current = androidPluginInfo.getPluginVersion();
        GradleVersion recommended = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
        return RecommendedPluginVersionUpgradeStep.shouldRecommendUpgrade(recommended, current);
    }

    @VisibleForTesting
    static boolean shouldRecommendUpgrade(@NotNull GradleVersion recommended, @Nullable GradleVersion current) {
        if (current != null) {
            if (recommended.isSnapshot() && current.compareIgnoringQualifiers(recommended) == 0) {
                return false;
            }
            if (current.isPreview() && recommended.isPreview() && !recommended.isSnapshot()) {
                return false;
            }
            if (!current.isPreview() && recommended.isPreview() && current.compareIgnoringQualifiers(recommended) < 0) {
                return true;
            }
            return current.compareTo(recommended) < 0;
        }
        return false;
    }
}

