/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeBasedUpgradeReminder {
    public static final String SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME = "show.do.not.ask.upgrade.gradle.plugin";
    private static final String SYNC_PLUGIN_LAST_UPGRADE_TIMESTAMP_PROPERTY = "sync.plugin.last.upgrade.timestamp";

    boolean shouldRecommendUpgrade(@NotNull Project project) {
        return this.shouldRecommendUpgrade(project, System.currentTimeMillis());
    }

    @VisibleForTesting
    boolean shouldRecommendUpgrade(@NotNull Project project, long currentTimeInMs) {
        String lastTimestampValue = this.getStoredTimestamp(project);
        if (StringUtil.isNotEmpty((String)lastTimestampValue)) {
            try {
                long lastTimestamp = Long.parseLong(lastTimestampValue);
                long elapsed = currentTimeInMs - lastTimestamp;
                long days = TimeUnit.MILLISECONDS.toDays(elapsed);
                return days >= 1L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    @Nullable
    String getStoredTimestamp(@NotNull Project project) {
        return PropertiesComponent.getInstance((Project)project).getValue(SYNC_PLUGIN_LAST_UPGRADE_TIMESTAMP_PROPERTY);
    }

    void storeLastUpgradeRecommendation(@NotNull Project project) {
        this.storeLastUpgradeRecommendation(project, System.currentTimeMillis());
    }

    @VisibleForTesting
    void storeLastUpgradeRecommendation(@NotNull Project project, long currentTimeInMs) {
        PropertiesComponent.getInstance((Project)project).setValue(SYNC_PLUGIN_LAST_UPGRADE_TIMESTAMP_PROPERTY, String.valueOf(currentTimeInMs));
    }

    boolean shouldAskForUpgrade(@NotNull Project project) {
        GradleVersion currentVersion;
        AndroidPluginInfo info = AndroidPluginInfo.find(project);
        if (info != null && (currentVersion = info.getPluginVersion()) != null) {
            return !Objects.equals(currentVersion.toString(), this.getDoNotAskAgainVersion(project));
        }
        return false;
    }

    void setDoNotAskAgainVersion(@NotNull Project project, @NotNull String ignoredVersion) {
        PropertiesComponent.getInstance((Project)project).setValue(SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME, ignoredVersion);
    }

    @NotNull
    String getDoNotAskAgainVersion(@NotNull Project project) {
        return PropertiesComponent.getInstance((Project)project).getValue(SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME, "");
    }
}

