/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.common;

import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.common.CommonProjectValidationStrategy;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class UniquePathModuleValidatorStrategy
extends CommonProjectValidationStrategy {
    @NotNull
    private final Multimap<String, Module> myModulesByPath = HashMultimap.create();

    UniquePathModuleValidatorStrategy(@NotNull Project project) {
        super(project);
    }

    @Override
    void validate(@NotNull Module module) {
        if (!GradleProjects.isIdeaAndroidModule(module)) {
            return;
        }
        File moduleFolderPath = GradleProjects.findModuleRootFolderPath(module);
        if (moduleFolderPath != null) {
            this.myModulesByPath.put((Object)moduleFolderPath.getPath(), (Object)module);
        }
    }

    @Override
    void fixAndReportFoundIssues() {
        Set modulePaths = this.myModulesByPath.keySet();
        for (String modulePath : modulePaths) {
            ArrayList<Module> modules = new ArrayList<Module>(this.myModulesByPath.get((Object)modulePath));
            modules.sort(Comparator.comparing(Module::getName));
            int moduleCount = modules.size();
            if (moduleCount <= 1) continue;
            StringBuilder msg = new StringBuilder();
            msg.append("The modules [");
            int i2 = 0;
            for (Module module : modules) {
                if (i2++ != 0) {
                    msg.append(", ");
                }
                String name = module.getName();
                msg.append("'").append(name).append("'");
            }
            msg.append("] point to the same directory in the file system.");
            String[] lines = new String[]{msg.toString(), "Each module must have a unique path."};
            SyncMessage message2 = new SyncMessage("Project Structure Issues", MessageType.ERROR, lines);
            Project project = this.getProject();
            GradleSyncMessages.getInstance(project).report(message2);
        }
    }

    @VisibleForTesting
    @NotNull
    Multimap<String, Module> getModulesByPath() {
        return this.myModulesByPath;
    }
}

