/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class GradleModuleTasksProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Module[] myModules;

    GradleModuleTasksProvider(@NotNull Module[] modules) {
        this.myModules = modules;
        if (this.myModules.length == 0) {
            throw new IllegalArgumentException("No modules provided");
        }
        this.myProject = this.myModules[0].getProject();
    }

    @NotNull
    public ListMultimap<Path, String> getUnitTestTasks(@NotNull BuildMode buildMode) {
        Module[] affectedModules = GradleModuleTasksProvider.getAffectedModules(this.myProject, this.myModules);
        return GradleTaskFinder.getInstance().findTasksToExecuteForTest(affectedModules, this.myModules, buildMode, TestCompileType.UNIT_TESTS);
    }

    @NotNull
    private static Module[] getAffectedModules(@NotNull Project project, @NotNull Module[] modules) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        CompileScope scope = compilerManager.createModulesCompileScope(modules, true, true);
        return scope.getAffectedModules();
    }

    @NotNull
    public ListMultimap<Path, String> getTasksFor(@NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        return GradleTaskFinder.getInstance().findTasksToExecute(this.myModules, buildMode, testCompileType);
    }
}

