/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.Semaphore;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.tooling.BuildAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GradleTaskRunner {
    public boolean run(@NotNull ListMultimap<Path, String> var1, @Nullable BuildMode var2, @NotNull List<String> var3) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static DefaultGradleTaskRunner newRunner(@NotNull Project project) {
        return new DefaultGradleTaskRunner(project);
    }

    @NotNull
    public static DefaultGradleTaskRunner newBuildActionRunner(@NotNull Project project, @Nullable BuildAction buildAction) {
        return new DefaultGradleTaskRunner(project, buildAction);
    }

    public static class DefaultGradleTaskRunner
    implements GradleTaskRunner {
        private Project myProject;
        @NotNull
        private final AtomicReference<Object> model = new AtomicReference();
        @Nullable
        final BuildAction myBuildAction;

        DefaultGradleTaskRunner(@NotNull Project project) {
            this(project, null);
        }

        DefaultGradleTaskRunner(@NotNull Project project, @Nullable BuildAction buildAction) {
            this.myProject = project;
            this.myBuildAction = buildAction;
        }

        @Override
        public boolean run(@NotNull ListMultimap<Path, String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments) {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            final GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(this.myProject);
            final AtomicBoolean success = new AtomicBoolean();
            final Semaphore done = new Semaphore();
            done.down();
            GradleBuildInvoker.AfterGradleInvocationTask afterTask = new GradleBuildInvoker.AfterGradleInvocationTask(){

                @Override
                public void execute(@NotNull GradleInvocationResult result2) {
                    success.set(result2.isBuildSuccessful());
                    model.set(result2.getModel());
                    gradleBuildInvoker.remove(this);
                    done.up();
                }
            };
            TransactionGuard.submitTransaction((Disposable)this.myProject, () -> {
                gradleBuildInvoker.add(afterTask);
                gradleBuildInvoker.executeTasks(tasks, buildMode, commandLineArguments, this.myBuildAction);
            });
            done.waitFor();
            boolean successful = success.get();
            return successful;
        }

        @Nullable
        public Object getModel() {
            return this.model.get();
        }

        @Nullable
        BuildAction getBuildAction() {
            return this.myBuildAction;
        }
    }
}

