/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.builder.model.TestedTargetVariant;
import com.android.ddmlib.IDevice;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.run.AndroidDeviceSpec;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.DefaultGradleBuilder;
import com.android.tools.idea.gradle.run.GradleEditTaskDialog;
import com.android.tools.idea.gradle.run.GradleModuleTasksProvider;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.AndroidAppRunConfigurationBase;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import icons.AndroidIcons;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeBeforeRunTaskProvider
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    @NotNull
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Android.Gradle.BeforeRunTask");
    private static int DEVICE_SPEC_TIMEOUT_SECONDS = 10;
    public static final String TASK_NAME = "Gradle-aware Make";
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final GradleTaskRunnerFactory myTaskRunnerFactory;

    public MakeBeforeRunTaskProvider(@NotNull Project project, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleProjectInfo gradleProjectInfo) {
        this.myProject = project;
        this.myAndroidProjectInfo = androidProjectInfo;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myTaskRunnerFactory = new GradleTaskRunnerFactory(this.myProject, GradleVersions.getInstance());
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(MakeBeforeRunTask task) {
        return AndroidIcons.Android;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String getDescription(MakeBeforeRunTask task) {
        String goal = task.getGoal();
        return StringUtil.isEmpty((String)goal) ? TASK_NAME : "gradle " + goal;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public MakeBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (this.configurationTypeIsSupported(runConfiguration)) {
            MakeBeforeRunTask task = new MakeBeforeRunTask();
            if (this.configurationTypeIsEnabledByDefault(runConfiguration)) {
                task.setEnabled(true);
            }
            return task;
        }
        return null;
    }

    public boolean configurationTypeIsSupported(@NotNull RunConfiguration runConfiguration) {
        if (this.myAndroidProjectInfo.isApkProject()) {
            return false;
        }
        return runConfiguration instanceof PreferGradleMake || MakeBeforeRunTaskProvider.isUnitTestConfiguration(runConfiguration);
    }

    public boolean configurationTypeIsEnabledByDefault(@NotNull RunConfiguration runConfiguration) {
        return runConfiguration instanceof PreferGradleMake;
    }

    private static boolean isUnitTestConfiguration(@NotNull RunConfiguration runConfiguration) {
        return runConfiguration instanceof JUnitConfiguration || runConfiguration.getClass().getSimpleName().equals("TestNGConfiguration");
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull MakeBeforeRunTask task) {
        GradleEditTaskDialog dialog2 = new GradleEditTaskDialog(this.myProject);
        dialog2.setGoal(task.getGoal());
        dialog2.setAvailableGoals(this.createAvailableTasks());
        if (!dialog2.showAndGet()) {
            task.setInvalid();
            return false;
        }
        task.setGoal(dialog2.getGoal());
        return true;
    }

    @NotNull
    private List<String> createAvailableTasks() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList<String> gradleTasks = new ArrayList<String>();
        for (Module module : moduleManager.getModules()) {
            GradleModuleModel gradleModuleModel;
            GradleFacet facet = GradleFacet.getInstance(module);
            if (facet == null || (gradleModuleModel = facet.getGradleModuleModel()) == null) continue;
            gradleTasks.addAll(gradleModuleModel.getTaskNames());
        }
        return gradleTasks;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull MakeBeforeRunTask task) {
        return task.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull MakeBeforeRunTask task) {
        RunStats stats = RunStats.from(env);
        try {
            stats.beginBeforeRunTasks();
            boolean bl = this.doExecuteTask(context, configuration, env, task);
            return bl;
        }
        finally {
            stats.endBeforeRunTasks();
        }
    }

    @VisibleForTesting
    @Nullable
    String runGradleSyncIfNeeded(@NotNull RunConfiguration configuration, @NotNull DataContext context) {
        boolean syncNeeded = false;
        boolean forceFullVariantsSync = false;
        final AtomicReference errorMsgRef = new AtomicReference();
        if (GradleSyncState.getInstance(this.myProject).isSyncNeeded() != ThreeState.NO && (AndroidGradleBuildConfiguration.getInstance((Project)this.myProject).SYNC_PROJECT_BEFORE_BUILD || !MakeBeforeRunTaskProvider.isPostBuildSyncSupported(this.myProject, context, configuration))) {
            syncNeeded = true;
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            NdkModuleModel ndkModel = NdkModuleModel.get(module);
            if (ndkModel == null || ndkModel.getVariants().size() >= ndkModel.getNdkVariantNames().size()) continue;
            syncNeeded = true;
            forceFullVariantsSync = true;
            break;
        }
        if (syncNeeded) {
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_RUN_SYNC_NEEDED_BEFORE_RUNNING);
            request.runInBackground = false;
            request.forceFullVariantsSync = forceFullVariantsSync;
            GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request, new GradleSyncListener(){

                @Override
                public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                    errorMsgRef.set(errorMessage);
                }
            });
        }
        return (String)errorMsgRef.get();
    }

    private static boolean isPostBuildSyncSupported(@NotNull Project project, @NotNull DataContext context, @NotNull RunConfiguration configuration) {
        Module[] modules;
        for (Module module : modules = MakeBeforeRunTaskProvider.getModules(project, context, configuration)) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null || androidModuleModel.getFeatures().isPostBuildSyncSupported()) continue;
            return false;
        }
        return true;
    }

    private boolean doExecuteTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, MakeBeforeRunTask task) {
        List<String> cmdLineArgs;
        if (!this.myAndroidProjectInfo.requiresAndroidModel() || !this.myGradleProjectInfo.isDirectGradleBuildEnabled()) {
            CompileStepBeforeRun regularMake = new CompileStepBeforeRun(this.myProject);
            return regularMake.executeTask(context, configuration, env, new CompileStepBeforeRun.MakeBeforeRunTask());
        }
        String errorMsg = this.runGradleSyncIfNeeded(configuration, context);
        if (errorMsg != null) {
            MakeBeforeRunTaskProvider.getLog().info("Unable to launch 'Gradle-aware Make' task. Project sync failed with message: " + errorMsg);
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (configuration instanceof RunProfileWithCompileBeforeLaunchOption && ((RunProfileWithCompileBeforeLaunchOption)configuration).isExcludeCompileBeforeLaunchOption()) {
            return true;
        }
        Module[] modules = MakeBeforeRunTaskProvider.getModules(this.myProject, context, configuration);
        DeviceFutures deviceFutures = (DeviceFutures)env.getCopyableUserData(DeviceFutures.KEY);
        List<AndroidDevice> targetDevices = deviceFutures == null ? Collections.emptyList() : deviceFutures.getDevices();
        try {
            cmdLineArgs = MakeBeforeRunTaskProvider.getCommonArguments(modules, configuration, targetDevices);
        }
        catch (Exception e) {
            MakeBeforeRunTaskProvider.getLog().warn("Error generating command line arguments for Gradle task", (Throwable)e);
            return false;
        }
        BeforeRunBuilder builder = MakeBeforeRunTaskProvider.createBuilder(modules, configuration, targetDevices, task.getGoal());
        GradleTaskRunner.DefaultGradleTaskRunner runner = this.myTaskRunnerFactory.createTaskRunner(configuration);
        BuildSettings.getInstance(this.myProject).setRunConfigurationTypeId(configuration.getType().getId());
        try {
            boolean success = builder.build(runner, cmdLineArgs);
            if (configuration instanceof AndroidRunConfigurationBase) {
                Object model2 = runner.getModel();
                if (model2 instanceof OutputBuildAction.PostBuildProjectModels) {
                    ((AndroidRunConfigurationBase)configuration).setOutputModel(new PostBuildModel((OutputBuildAction.PostBuildProjectModels)model2));
                } else {
                    MakeBeforeRunTaskProvider.getLog().info("Couldn't get post build models.");
                }
            }
            MakeBeforeRunTaskProvider.getLog().info("Gradle invocation complete, success = " + success);
            return success;
        }
        catch (InvocationTargetException e) {
            MakeBeforeRunTaskProvider.getLog().info("Unexpected error while launching gradle before run tasks", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            MakeBeforeRunTaskProvider.getLog().info("Interrupted while launching gradle before run tasks");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(MakeBeforeRunTask.class);
    }

    @NotNull
    private static List<String> getCommonArguments(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) throws IOException {
        ArrayList<String> cmdLineArgs = new ArrayList<String>();
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getDeviceSpecificArguments(modules, configuration, targetDevices));
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getProfilingOptions(configuration, targetDevices));
        return cmdLineArgs;
    }

    @NotNull
    public static List<String> getDeviceSpecificArguments(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> devices) throws IOException {
        AndroidDeviceSpec deviceSpec = AndroidDeviceSpec.create(devices, MakeBeforeRunTaskProvider.shouldCollectListOfLanguages(modules, configuration, devices), DEVICE_SPEC_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        if (deviceSpec == null) {
            return Collections.emptyList();
        }
        ArrayList<String> properties = new ArrayList<String>(2);
        if (MakeBeforeRunTaskProvider.useSelectApksFromBundleBuilder(modules, configuration, devices)) {
            File deviceSpecFile = deviceSpec.writeToJsonTempFile();
            properties.add(AndroidGradleSettings.createProjectProperty((String)"android.inject.apkselect.config", (String)deviceSpecFile.getAbsolutePath()));
            if (configuration instanceof AndroidAppRunConfigurationBase && ((AndroidAppRunConfigurationBase)configuration).DEPLOY_AS_INSTANT) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.inject.bundle.extractinstant", (boolean)true));
            }
        } else {
            properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.api", (String)Integer.toString(deviceSpec.getApiLevel())));
            if (deviceSpec.getApiCodeName() != null) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.codename", (String)deviceSpec.getApiCodeName()));
            }
            if (deviceSpec.getBuildDensity() != null) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.density", (String)deviceSpec.getBuildDensity().getResourceValue()));
            }
            if (!deviceSpec.getBuildAbis().isEmpty()) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.abi", (String)Joiner.on((char)',').join(deviceSpec.getBuildAbis())));
            }
            if (configuration instanceof AndroidAppRunConfigurationBase && ((AndroidAppRunConfigurationBase)configuration).DEPLOY_AS_INSTANT) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.deploy.instant-app", (boolean)true));
            }
        }
        return properties;
    }

    @NotNull
    private static List<String> getProfilingOptions(@NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> devices) throws IOException {
        if (!(configuration instanceof AndroidRunConfigurationBase) || devices.isEmpty()) {
            return Collections.emptyList();
        }
        List versionLists = devices.stream().map(AndroidDevice::getVersion).collect(Collectors.toList());
        AndroidVersion minVersion = (AndroidVersion)Ordering.natural().min(versionLists);
        LinkedList<String> arguments = new LinkedList<String>();
        ProfilerState state = ((AndroidRunConfigurationBase)configuration).getProfilerState();
        if (state.ADVANCED_PROFILING_ENABLED && minVersion.getFeatureLevel() >= 21 && minVersion.getFeatureLevel() < 26) {
            File file = EmbeddedDistributionPaths.getInstance().findEmbeddedProfilerTransform(minVersion);
            arguments.add(AndroidGradleSettings.createProjectProperty((String)"android.advanced.profiling.transforms", (String)file.getAbsolutePath()));
            Properties profilerProperties = state.toProperties();
            File propertiesFile = FileUtil.createTempFile((String)"profiler", (String)".properties");
            propertiesFile.deleteOnExit();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), Charsets.UTF_8);
            profilerProperties.store(writer, "Android Studio Profiler Gradle Plugin Properties");
            ((Writer)writer).close();
            arguments.add(AndroidGradleSettings.createJvmArg((String)"android.profiler.properties", (String)propertiesFile.getAbsolutePath()));
        }
        return arguments;
    }

    @NotNull
    private static BeforeRunBuilder createBuilder(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices, @Nullable String userGoal) {
        if (modules.length == 0) {
            throw new IllegalStateException("Unable to determine list of modules to build");
        }
        if (!StringUtil.isEmpty((String)userGoal)) {
            ArrayListMultimap tasks = ArrayListMultimap.create();
            ((StreamEx)StreamEx.of((Object[])modules).map(module -> ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)).nonNull().distinct()).map(path -> Paths.get(path, new String[0])).forEach(arg_0 -> MakeBeforeRunTaskProvider.lambda$createBuilder$2((ListMultimap)tasks, userGoal, arg_0));
            return new DefaultGradleBuilder((ListMultimap<Path, String>)tasks, null);
        }
        GradleModuleTasksProvider gradleTasksProvider = new GradleModuleTasksProvider(modules);
        TestCompileType testCompileType = TestCompileType.get(configuration.getType().getId());
        if (testCompileType == TestCompileType.UNIT_TESTS) {
            BuildMode buildMode = BuildMode.COMPILE_JAVA;
            return new DefaultGradleBuilder(gradleTasksProvider.getUnitTestTasks(buildMode), buildMode);
        }
        if (MakeBeforeRunTaskProvider.useSelectApksFromBundleBuilder(modules, configuration, targetDevices)) {
            return new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.APK_FROM_BUNDLE, testCompileType), BuildMode.APK_FROM_BUNDLE);
        }
        return new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.ASSEMBLE, testCompileType), BuildMode.ASSEMBLE);
    }

    private static boolean useSelectApksFromBundleBuilder(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        return Arrays.stream(modules).anyMatch(module -> DynamicAppUtils.useSelectApksFromBundleBuilder(module, configuration, targetDevices));
    }

    private static boolean shouldCollectListOfLanguages(@NotNull Module[] modules, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        return Arrays.stream(modules).allMatch(module -> DynamicAppUtils.shouldCollectListOfLanguages(module, configuration, targetDevices));
    }

    @NotNull
    private static Module[] getModules(@NotNull Project project, @Nullable DataContext context, @Nullable RunConfiguration configuration) {
        if (configuration instanceof ModuleRunProfile) {
            if (configuration instanceof AndroidJUnitConfiguration) {
                return ((AndroidJUnitConfiguration)configuration).getModulesToCompile();
            }
            return ((ModuleRunProfile)configuration).getModules();
        }
        return GradleProjects.getModulesToBuildFromSelection(project, context);
    }

    @Nullable
    public static IDevice getLaunchedDevice(@NotNull AndroidDevice device) {
        if (!device.getLaunchedDevice().isDone()) {
            return null;
        }
        try {
            return (IDevice)device.getLaunchedDevice().get(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$createBuilder$2(ListMultimap tasks, String userGoal, Path path) {
        tasks.put((Object)path, (Object)userGoal);
    }

    @VisibleForTesting
    static class GradleTaskRunnerFactory {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GradleVersions myGradleVersions;

        GradleTaskRunnerFactory(@NotNull Project project, @NotNull GradleVersions gradleVersions) {
            this.myProject = project;
            this.myGradleVersions = gradleVersions;
        }

        @NotNull
        GradleTaskRunner.DefaultGradleTaskRunner createTaskRunner(@NotNull RunConfiguration configuration) {
            GradleVersion version2;
            if (configuration instanceof AndroidRunConfigurationBase && (version2 = this.myGradleVersions.getGradleVersion(this.myProject)) != null && version2.isAtLeast(3, 5, 0)) {
                Module selectedModule = ((JavaRunConfigurationModule)((AndroidRunConfigurationBase)configuration).getConfigurationModule()).getModule();
                return GradleTaskRunner.newBuildActionRunner(this.myProject, new OutputBuildAction(GradleTaskRunnerFactory.getConcernedGradlePaths(selectedModule)));
            }
            return GradleTaskRunner.newRunner(this.myProject);
        }

        @NotNull
        private static Collection<String> getConcernedGradlePaths(@Nullable Module module) {
            IdeAndroidProject androidProject;
            if (module == null) {
                return Collections.emptySet();
            }
            HashSet<String> gradlePaths = new HashSet<String>();
            gradlePaths.add(GradleUtil.getGradlePath(module));
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel != null && (androidProject = androidModel.getAndroidProject()).getProjectType() == 2) {
                for (TestedTargetVariant testedVariant : androidModel.getSelectedVariant().getTestedTargetVariants()) {
                    gradlePaths.add(testedVariant.getTargetProjectPath());
                }
            }
            return gradlePaths;
        }
    }
}

