/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.ProjectBuildOutput;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputBuildAction
implements BuildAction<PostBuildProjectModels>,
Serializable {
    @NotNull
    private final ImmutableCollection<String> myGradlePaths;

    public OutputBuildAction(@NotNull Collection<String> moduleGradlePaths) {
        this.myGradlePaths = ImmutableSet.copyOf(moduleGradlePaths);
    }

    public PostBuildProjectModels execute(@NotNull BuildController controller) {
        PostBuildProjectModels postBuildProjectModels = new PostBuildProjectModels();
        if (!this.myGradlePaths.isEmpty()) {
            BasicGradleProject rootProject = controller.getBuildModel().getRootProject();
            GradleProject root = (GradleProject)controller.findModel((Model)rootProject, GradleProject.class);
            postBuildProjectModels.populate(root, (Collection<String>)this.myGradlePaths, controller);
        }
        return postBuildProjectModels;
    }

    public static class PostBuildModuleModels
    implements Serializable {
        @NotNull
        private final GradleProject myGradleProject;
        @NotNull
        private final Map<Class, Object> myModelsByType = new HashMap<Class, Object>();

        private PostBuildModuleModels(@NotNull GradleProject gradleProject) {
            this.myGradleProject = gradleProject;
        }

        private void populate(@NotNull BuildController controller) {
            this.findAndAddModel(controller, AppBundleProjectBuildOutput.class);
            ProjectBuildOutput projectBuildOutput = this.findAndAddModel(controller, ProjectBuildOutput.class);
            if (projectBuildOutput != null) {
                return;
            }
            this.findAndAddModel(controller, InstantAppProjectBuildOutput.class);
        }

        @NotNull
        public String getGradlePath() {
            return this.myGradleProject.getPath();
        }

        @NotNull
        public String getModuleName() {
            return this.myGradleProject.getName();
        }

        @Nullable
        private <T> T findAndAddModel(@NotNull BuildController controller, @NotNull Class<T> modelType) {
            Object model2 = controller.findModel((Model)this.myGradleProject, modelType);
            if (model2 != null) {
                this.myModelsByType.put(modelType, model2);
            }
            return (T)model2;
        }

        public <T> boolean hasModel(@NotNull Class<T> modelType) {
            return this.findModel(modelType) != null;
        }

        @Nullable
        public <T> T findModel(@NotNull Class<T> modelType) {
            Object model2 = this.myModelsByType.get(modelType);
            if (model2 != null) {
                assert (modelType.isInstance(model2));
                return modelType.cast(model2);
            }
            return null;
        }
    }

    public static class PostBuildProjectModels
    implements Serializable {
        @NotNull
        private final Map<String, PostBuildModuleModels> myModelsByModule = new HashMap<String, PostBuildModuleModels>();

        private PostBuildProjectModels() {
        }

        public void populate(@NotNull GradleProject rootProject, @NotNull Collection<String> gradleModulePaths, @NotNull BuildController controller) {
            for (String gradleModulePath : gradleModulePaths) {
                this.populateModule(rootProject, gradleModulePath, controller);
            }
        }

        private void populateModule(@NotNull GradleProject rootProject, @NotNull String moduleProjectPath, @NotNull BuildController controller) {
            if (this.myModelsByModule.containsKey(moduleProjectPath)) {
                return;
            }
            GradleProject moduleProject = rootProject.findByPath(moduleProjectPath);
            if (moduleProject != null) {
                PostBuildModuleModels models = new PostBuildModuleModels(moduleProject);
                models.populate(controller);
                this.myModelsByModule.put(moduleProject.getPath(), models);
            }
        }

        @Nullable
        public PostBuildModuleModels getModels(@NotNull String gradlePath) {
            return this.myModelsByModule.get(gradlePath);
        }
    }
}

