/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.tools.idea.gradle.structure.AndroidProjectStructureConfigurable;
import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.npw.PathValidationResult;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSdksConfigurable
implements Place.Navigator,
Configurable {
    @NonNls
    private static final String SDKS_PLACE = "sdks.place";
    @NonNls
    public static final String IDE_SDKS_LOCATION_VIEW = "IdeSdksView";
    private static final String CHOOSE_VALID_JDK_DIRECTORY_ERR_FORMAT = "Please choose a valid JDK %s directory.";
    private static final String CHOOSE_VALID_SDK_DIRECTORY_ERR = "Please choose a valid Android SDK directory.";
    private static final String CHOOSE_VALID_NDK_DIRECTORY_ERR = "Please choose a valid Android NDK directory.";
    public static final String JDK_LOCATION_WARNING = "To use the same Gradle daemon between Android Studio and the command line, select JAVA_HOME from the drop-down.";
    public static final String JDK_LOCATION_WARNING_URL = "https://docs.gradle.org/current/userguide/gradle_daemon.html#sec:why_is_there_more_than_one_daemon_process_on_my_machine";
    private static final Logger LOG = Logger.getInstance(IdeSdksConfigurable.class);
    @Nullable
    private final Configurable myHost;
    @Nullable
    private final Project myProject;
    @NotNull
    private final BiMap<String, Component> myComponentsById;
    @NotNull
    private String myUserSelectedJdkHomePath;
    @Nullable
    private String myOriginalNdkHomePath;
    @Nullable
    private String myOriginalSdkHomePath;
    @Nullable
    private String myOriginalJdkHomePath;
    private HyperlinkLabel myNdkDownloadHyperlinkLabel;
    private TextFieldWithBrowseButton mySdkLocationTextField;
    private JPanel myWholePanel;
    private JPanel myNdkDownloadPanel;
    private JPanel myJdkWarningPanel;
    private AsyncProcessIcon myNdkCheckProcessIcon;
    private ComboboxWithBrowseButton myJdkLocationComboBox;
    private ComboboxWithBrowseButton myNdkLocationComboBox;
    private HyperlinkLabel myJdkWarningLink;
    private DetailsComponent myDetailsComponent;
    private History myHistory;
    private String mySelectedComponentId;
    private boolean mySdkLoadingRequested;
    private JLabel myJdkWarningLabel;

    public IdeSdksConfigurable(@Nullable Configurable host, @Nullable Project project) {
        this.$$$setupUI$$$();
        this.myComponentsById = HashBiMap.create();
        this.myUserSelectedJdkHomePath = "";
        this.mySdkLoadingRequested = false;
        this.myHost = host;
        this.myProject = project;
        this.myWholePanel.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        this.myWholePanel.setName(IDE_SDKS_LOCATION_VIEW);
        this.myDetailsComponent = new DetailsComponent(false, false);
        this.myDetailsComponent.setContent((JComponent)this.myWholePanel);
        if (this.myProject == null || this.myProject.isDefault()) {
            this.myNdkLocationComboBox.setEnabled(false);
        }
        this.adjustNdkQuickFixVisibility();
        FocusAdapter historyUpdater = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (IdeSdksConfigurable.this.myHistory != null) {
                    String id = (String)IdeSdksConfigurable.this.myComponentsById.inverse().get((Object)e.getComponent());
                    IdeSdksConfigurable.this.mySelectedComponentId = id;
                    if (id != null) {
                        IdeSdksConfigurable.this.myHistory.pushQueryPlace();
                    }
                }
            }
        };
        this.installValidationListener(this.mySdkLocationTextField.getTextField());
        this.addHistoryUpdater("mySdkLocationTextField", this.mySdkLocationTextField.getTextField(), historyUpdater);
        this.addHistoryUpdater("myJdkLocationComboBox", this.myJdkLocationComboBox.getComboBox(), historyUpdater);
        this.addHistoryUpdater("myNdkLocationComboBox", this.myNdkLocationComboBox.getComboBox(), historyUpdater);
    }

    private void maybeLoadSdks(@Nullable Project project) {
        if (this.mySdkLoadingRequested) {
            return;
        }
        this.mySdkLoadingRequested = true;
        CardLayout layout2 = (CardLayout)this.myNdkDownloadPanel.getLayout();
        layout2.show(this.myNdkDownloadPanel, "loading");
        StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager repoManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getSdkManager((ProgressIndicator)logger);
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Loading Remote SDK", project);
        RepoManager.RepoLoadedCallback onComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            if (packages.getRemotePackages().get("ndk-bundle") != null) {
                layout2.show(this.myNdkDownloadPanel, "link");
            } else {
                this.myNdkDownloadPanel.setVisible(false);
            }
        }, ModalityState.any());
        Runnable onError = () -> ApplicationManager.getApplication().invokeLater(() -> this.myNdkDownloadPanel.setVisible(false), ModalityState.any());
        repoManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private void addHistoryUpdater(@NotNull String id, @NotNull Component c, @NotNull FocusListener historyUpdater) {
        this.myComponentsById.put((Object)id, (Object)c);
        c.addFocusListener(historyUpdater);
    }

    public void disposeUIResources() {
        this.mySdkLoadingRequested = false;
    }

    public void reset() {
        this.myOriginalSdkHomePath = IdeSdksConfigurable.getIdeAndroidSdkPath();
        this.myOriginalNdkHomePath = this.getIdeNdkPath();
        this.myOriginalJdkHomePath = IdeSdksConfigurable.getIdeJdkPath();
        this.mySdkLocationTextField.setText(this.myOriginalSdkHomePath);
        this.myNdkLocationComboBox.getComboBox().setSelectedItem(this.myOriginalNdkHomePath);
        this.myJdkLocationComboBox.getComboBox().setSelectedItem(this.myOriginalJdkHomePath);
        this.setJdkWarningVisibility();
        this.myUserSelectedJdkHomePath = this.myOriginalJdkHomePath;
    }

    public void apply() throws ConfigurationException {
        if (!this.isModified()) {
            return;
        }
        if (this.validateJdkPath(this.getJdkLocation()) == null) {
            throw new ConfigurationException(IdeSdksConfigurable.generateChooseValidJdkDirectoryError());
        }
        List<ProjectConfigurationError> errors = this.validateState();
        if (!errors.isEmpty()) {
            throw new ConfigurationException(errors.get(0).getDescription());
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.saveAndroidNdkPath();
            IdeSdks ideSdks = IdeSdks.getInstance();
            ideSdks.setJdkPath(this.getJdkLocation());
            ideSdks.setAndroidSdkPath(this.getSdkLocation(), this.myProject);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                IdeSdks.updateWelcomeRunAndroidSdkAction();
            }
        });
    }

    @NotNull
    public static String generateChooseValidJdkDirectoryError() {
        return String.format(CHOOSE_VALID_JDK_DIRECTORY_ERR_FORMAT, IdeSdks.getInstance().getRunningVersionOrDefault().getDescription());
    }

    private void saveAndroidNdkPath() {
        if (this.myProject == null || this.myProject.isDefault()) {
            return;
        }
        try {
            LocalProperties localProperties = new LocalProperties(this.myProject);
            localProperties.setAndroidNdkPath(this.getNdkLocation());
            localProperties.save();
        }
        catch (IOException e) {
            LOG.info(String.format("Unable to update local.properties file in project '%1$s'.", this.myProject.getName()), (Throwable)e);
            String cause = e.getMessage();
            if (Strings.isNullOrEmpty((String)cause)) {
                cause = "[Unknown]";
            }
            String msg = String.format("Unable to update local.properties file in project '%1$s'.\n\nCause: %2$s\n\nPlease manually update the file's '%3$s' property value to \n'%4$s'\nand sync the project with Gradle files.", this.myProject.getName(), cause, "ndk.dir", this.getNdkLocation().getPath());
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Android Ndk Update");
        }
    }

    private void createUIComponents() {
        this.myNdkCheckProcessIcon = new AsyncProcessIcon("NDK check progress");
        this.createSdkLocationTextField();
        this.createNdkLocationComboBox();
        this.createNdkDownloadLink();
        this.createJdkLocationWarningLabel();
        this.createJdkLocationComboBox();
    }

    private void createJdkLocationWarningLabel() {
        this.myJdkWarningLink = new HyperlinkLabel();
        this.myJdkWarningLabel = new JLabel();
        IdeSdksConfigurable.setUpJdkWarningLabelAndLink(this.myJdkWarningLabel, this.myJdkWarningLink);
    }

    public static void setUpJdkWarningLabelAndLink(JLabel label, @NotNull HyperlinkLabel link) {
        label.setText(JDK_LOCATION_WARNING);
        label.setIcon(StudioIcons.Common.INFO_INLINE);
        label.setVisible(true);
        label.addNotify();
        link.setHyperlinkText("More info...");
        link.setHyperlinkTarget(JDK_LOCATION_WARNING_URL);
        link.setVisible(true);
        link.setEnabled(true);
        link.addNotify();
    }

    private void createNdkLocationComboBox() {
        FileChooserDescriptor descriptor2 = IdeSdksConfigurable.createSingleFolderDescriptor("Choose NDK Location", (Function<File, Void>)((Function)file -> {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidNdk(file, false);
            if (!validationResult.success) {
                this.adjustNdkQuickFixVisibility();
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_NDK_DIRECTORY_ERR;
                }
                throw new IllegalArgumentException(msg);
            }
            JComboBox comboBox = this.myNdkLocationComboBox.getComboBox();
            IdeSdksConfigurable.setComboBoxFile(comboBox, file);
            return null;
        }));
        this.myNdkLocationComboBox = new ComboboxWithBrowseButton();
        this.myNdkLocationComboBox.addBrowseFolderListener(this.myProject, descriptor2);
        final JComboBox comboBox = this.myNdkLocationComboBox.getComboBox();
        File androidNdkPath = IdeSdks.getInstance().getAndroidNdkPath();
        if (androidNdkPath != null) {
            comboBox.addItem(new LabelAndFileForLocation("Default NDK (recommended)", androidNdkPath));
        }
        comboBox.setEditable(true);
        comboBox.setSelectedItem(IdeSdksConfigurable.getIdeAndroidSdkPath());
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Object selectedItem;
                if (event.getStateChange() == 1 && (selectedItem = event.getItem()) instanceof LabelAndFileForLocation) {
                    ApplicationManager.getApplication().invokeLater(() -> IdeSdksConfigurable.setComboBoxFile(comboBox, ((LabelAndFileForLocation)selectedItem).getFile()));
                }
            }
        });
    }

    private void createJdkLocationComboBox() {
        File validatedPath;
        String javaHomePath;
        File validatedPath2;
        FileChooserDescriptor descriptor2 = IdeSdksConfigurable.createSingleFolderDescriptor("Choose JDK Location", (Function<File, Void>)((Function)file -> {
            File validatedFile = this.validateJdkPath((File)file);
            if (validatedFile == null) {
                throw new IllegalArgumentException(IdeSdksConfigurable.generateChooseValidJdkDirectoryError());
            }
            this.setJdkLocationComboBox((File)file);
            return null;
        }));
        this.myJdkLocationComboBox = new ComboboxWithBrowseButton();
        this.myJdkLocationComboBox.addBrowseFolderListener(this.myProject, descriptor2);
        JComboBox comboBox = this.myJdkLocationComboBox.getComboBox();
        IdeSdks ideSdks = IdeSdks.getInstance();
        File embeddedPath = ideSdks.getEmbeddedJdkPath();
        if (embeddedPath != null && (validatedPath2 = this.validateJdkPath(embeddedPath)) != null) {
            comboBox.addItem(new LabelAndFileForLocation("Embedded JDK", validatedPath2));
        }
        if ((javaHomePath = IdeSdks.getJdkFromJavaHome()) != null && (validatedPath = this.validateJdkPath(new File(javaHomePath))) != null) {
            comboBox.addItem(new LabelAndFileForLocation("JAVA_HOME", validatedPath));
        }
        comboBox.setEditable(true);
        IdeSdksConfigurable.setComboBoxFile(comboBox, this.getJdkLocation());
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Object selectedItem;
                if (event.getStateChange() == 1 && (selectedItem = event.getItem()) instanceof LabelAndFileForLocation) {
                    ApplicationManager.getApplication().invokeLater(() -> IdeSdksConfigurable.this.setJdkLocationComboBox(((LabelAndFileForLocation)selectedItem).getFile()));
                }
            }
        });
        this.setJdkWarningVisibility();
    }

    private static void setComboBoxFile(@NotNull JComboBox comboBox, @NotNull File file) {
        comboBox.setSelectedItem(FileUtilRt.toSystemDependentName((String)file.getPath()));
    }

    private void createSdkLocationTextField() {
        FileChooserDescriptor descriptor2 = IdeSdksConfigurable.createSingleFolderDescriptor("Choose Android SDK Location", (Function<File, Void>)((Function)file -> {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(file, false);
            if (!validationResult.success) {
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_SDK_DIRECTORY_ERR;
                }
                throw new IllegalArgumentException(msg);
            }
            return null;
        }));
        JTextField textField2 = new JTextField(10);
        this.mySdkLocationTextField = new TextFieldWithBrowseButton(textField2, e -> {
            VirtualFile chosen;
            VirtualFile suggestedDir = null;
            File sdkLocation = this.getSdkLocation();
            if (sdkLocation.isDirectory()) {
                suggestedDir = VfsUtil.findFileByIoFile((File)sdkLocation, (boolean)false);
            }
            if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, null, (VirtualFile)suggestedDir)) != null) {
                File f = VfsUtilCore.virtualToIoFile((VirtualFile)chosen);
                textField2.setText(FileUtilRt.toSystemDependentName((String)f.getPath()));
            }
        });
    }

    private void createNdkDownloadLink() {
        this.myNdkDownloadHyperlinkLabel = new HyperlinkLabel();
        this.myNdkDownloadHyperlinkLabel.setHyperlinkText("", "Download", " Android NDK.");
        this.myNdkDownloadHyperlinkLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (IdeSdksConfigurable.this.validateAndroidSdkPath() != null) {
                    Messages.showErrorDialog((Component)IdeSdksConfigurable.this.getContentPanel(), (String)"Please select a valid SDK before downloading the NDK.");
                    return;
                }
                ImmutableList requested = ImmutableList.of((Object)"ndk-bundle");
                ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(IdeSdksConfigurable.this.myWholePanel, (Collection<String>)requested, false);
                if (dialog2 != null && dialog2.showAndGet()) {
                    File ndk = IdeSdks.getInstance().getAndroidNdkPath();
                    if (ndk != null) {
                        IdeSdksConfigurable.this.myNdkLocationComboBox.getComboBox().setSelectedItem(FileUtilRt.toSystemDependentName((String)ndk.getPath()));
                    }
                    IdeSdksConfigurable.this.validateState();
                }
            }
        });
    }

    public void chooseJdkLocation() {
        VirtualFile chosen;
        JComboBox comboBox = this.myJdkLocationComboBox.getComboBox();
        comboBox.requestFocus();
        VirtualFile suggestedDir = null;
        File jdkLocation = this.getUserSelectedJdkLocation();
        if (jdkLocation.isDirectory()) {
            suggestedDir = VfsUtil.findFileByIoFile((File)jdkLocation, (boolean)false);
        }
        if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)IdeSdksConfigurable.createSingleFolderDescriptor("Choose JDK Location", (Function<File, Void>)((Function)file -> {
            if (this.validateJdkPath((File)file) == null) {
                throw new IllegalArgumentException(IdeSdksConfigurable.generateChooseValidJdkDirectoryError());
            }
            return null;
        })), null, (VirtualFile)suggestedDir)) != null) {
            File validJdkLocation = this.validateJdkPath(VfsUtilCore.virtualToIoFile((VirtualFile)chosen));
            assert (validJdkLocation != null);
            this.myUserSelectedJdkHomePath = validJdkLocation.getPath();
            this.setJdkLocationComboBox(validJdkLocation);
        }
    }

    private void installValidationListener(@NotNull JTextField textField2) {
        if (this.myHost instanceof AndroidProjectStructureConfigurable) {
            textField2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    ((AndroidProjectStructureConfigurable)IdeSdksConfigurable.this.myHost).requestValidation();
                }
            });
        }
    }

    @NotNull
    private static FileChooserDescriptor createSingleFolderDescriptor(@NotNull String title, final @NotNull Function<File, Void> validation2) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(@NotNull VirtualFile[] files2) {
                for (VirtualFile virtualFile : files2) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    validation2.fun((Object)file);
                }
            }
        };
        if (SystemInfo.isMac) {
            descriptor2.withShowHiddenFiles(true);
        }
        descriptor2.setTitle(title);
        return descriptor2;
    }

    public String getDisplayName() {
        return "SDK Location";
    }

    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        this.maybeLoadSdks(this.myProject);
        return this.myDetailsComponent.getComponent();
    }

    @NotNull
    public JComponent getContentPanel() {
        return this.myWholePanel;
    }

    public boolean isModified() {
        return !Objects.equals(this.myOriginalSdkHomePath, this.getSdkLocation().getPath()) || !Objects.equals(this.myOriginalNdkHomePath, this.getNdkLocation().getPath()) || !Objects.equals(this.myOriginalJdkHomePath, this.getJdkLocation().getPath());
    }

    @Nullable
    private static Sdk getFirstDefaultAndroidSdk() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        List<Sdk> allAndroidSdks = ideSdks.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdkData == null) {
            return null;
        }
        List<Sdk> sdks = ideSdks.createAndroidSdkPerAndroidTarget(sdkData.getLocation());
        return !sdks.isEmpty() ? sdks.get(0) : null;
    }

    @NotNull
    private static String getIdeAndroidSdkPath() {
        String sdkHome;
        File path = IdeSdks.getInstance().getAndroidSdkPath();
        if (path != null) {
            return path.getPath();
        }
        Sdk sdk = IdeSdksConfigurable.getFirstDefaultAndroidSdk();
        if (sdk != null && (sdkHome = sdk.getHomePath()) != null) {
            return FileUtilRt.toSystemDependentName((String)sdkHome);
        }
        return "";
    }

    @NotNull
    private String getIdeNdkPath() {
        if (this.myProject != null && !this.myProject.isDefault()) {
            try {
                File androidNdkPath = new LocalProperties(this.myProject).getAndroidNdkPath();
                if (androidNdkPath != null) {
                    return androidNdkPath.getPath();
                }
            }
            catch (IOException e) {
                LOG.info(String.format("Unable to read local.properties file in project '%1$s'.", this.myProject.getName()), (Throwable)e);
            }
        } else {
            File path = IdeSdks.getInstance().getAndroidNdkPath();
            if (path != null) {
                return path.getPath();
            }
        }
        return "";
    }

    @NotNull
    private static String getIdeJdkPath() {
        File javaHome = IdeSdks.getInstance().getJdkPath();
        return javaHome != null ? javaHome.getPath() : "";
    }

    @NotNull
    private File getSdkLocation() {
        String sdkLocation = this.mySdkLocationTextField.getText();
        return FilePaths.toSystemDependentPath((String)sdkLocation);
    }

    @NotNull
    private File getNdkLocation() {
        return IdeSdksConfigurable.getLocationFromComboBoxWithBrowseButton(this.myNdkLocationComboBox);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Component toFocus = (Component)this.myComponentsById.get((Object)this.mySelectedComponentId);
        return toFocus instanceof JComponent ? (JComponent)toFocus : this.mySdkLocationTextField.getTextField();
    }

    public boolean validate() throws ConfigurationException {
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        if (this.validateJdkPath(this.getJdkLocation()) == null) {
            throw new ConfigurationException(IdeSdksConfigurable.generateChooseValidJdkDirectoryError());
        }
        msg = this.validateAndroidNdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        return true;
    }

    @NotNull
    public List<ProjectConfigurationError> validateState() {
        ProjectConfigurationError error;
        ArrayList errors = Lists.newArrayList();
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            error = new ProjectConfigurationError(msg, this.mySdkLocationTextField.getTextField());
            errors.add(error);
        }
        if (this.validateJdkPath(this.getJdkLocation()) == null) {
            error = new ProjectConfigurationError(IdeSdksConfigurable.generateChooseValidJdkDirectoryError(), this.myJdkLocationComboBox.getComboBox());
            errors.add(error);
        }
        if ((msg = this.validateAndroidNdkPath()) != null) {
            error = new ProjectConfigurationError(msg, this.myNdkLocationComboBox.getComboBox());
            errors.add(error);
        }
        return errors;
    }

    @Nullable
    private String validateAndroidSdkPath() {
        PathValidationResult wizardValidationResult = PathValidationResult.validateLocation(this.getSdkLocation().getAbsolutePath(), "Android SDK location", false, PathValidationResult.WritableCheckMode.DO_NOT_CHECK);
        if (!wizardValidationResult.isOk()) {
            return wizardValidationResult.getFormattedMessage();
        }
        SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(this.getSdkLocation(), false);
        if (!validationResult.success) {
            String msg = validationResult.message;
            if (StringUtil.isEmpty((String)msg)) {
                msg = CHOOSE_VALID_SDK_DIRECTORY_ERR;
            }
            return msg;
        }
        return null;
    }

    @Nullable
    private String validateAndroidNdkPath() {
        this.hideNdkQuickfixLink();
        Object selectedItem = this.myNdkLocationComboBox.getComboBox().getSelectedItem();
        String value2 = "";
        if (selectedItem != null) {
            value2 = selectedItem.toString();
        }
        if (!value2.isEmpty()) {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidNdk(this.getNdkLocation(), false);
            if (!validationResult.success) {
                this.adjustNdkQuickFixVisibility();
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_NDK_DIRECTORY_ERR;
                }
                return msg;
            }
        } else if (this.myNdkLocationComboBox.isVisible()) {
            this.adjustNdkQuickFixVisibility();
        }
        return null;
    }

    private void adjustNdkQuickFixVisibility() {
        boolean hasNdk = IdeSdks.getInstance().getAndroidNdkPath() != null;
        this.myNdkDownloadPanel.setVisible(!hasNdk);
    }

    private void hideNdkQuickfixLink() {
        this.myNdkDownloadPanel.setVisible(false);
    }

    @NotNull
    private File getUserSelectedJdkLocation() {
        String jdkLocation = Strings.nullToEmpty((String)this.myUserSelectedJdkHomePath);
        return FilePaths.toSystemDependentPath((String)jdkLocation);
    }

    @NotNull
    private File getJdkLocation() {
        return IdeSdksConfigurable.getLocationFromComboBoxWithBrowseButton(this.myJdkLocationComboBox);
    }

    @NotNull
    public static File getLocationFromComboBoxWithBrowseButton(@NotNull ComboboxWithBrowseButton comboboxWithBrowseButton) {
        Object item = comboboxWithBrowseButton.getComboBox().getEditor().getItem();
        if (item instanceof LabelAndFileForLocation) {
            return ((LabelAndFileForLocation)item).getFile();
        }
        String jdkLocation = item.toString();
        return FilePaths.toSystemDependentPath((String)jdkLocation);
    }

    @Nullable
    private File validateJdkPath(@NotNull File file) {
        File possiblePath = IdeSdks.getInstance().validateJdkPath(file);
        if (possiblePath != null) {
            this.setJdkLocationComboBox(possiblePath);
            return possiblePath;
        }
        return null;
    }

    private void setJdkLocationComboBox(@NotNull File path) {
        IdeSdksConfigurable.setComboBoxFile(this.myJdkLocationComboBox.getComboBox(), path);
        this.setJdkWarningVisibility();
    }

    private void setJdkWarningVisibility() {
        File jdkLocation = this.getJdkLocation();
        boolean visible = !IdeSdks.isSameAsJavaHomeJdk(jdkLocation);
        this.myJdkWarningLink.setVisible(visible);
        this.myJdkWarningLabel.setVisible(visible);
    }

    public static boolean isNeeded() {
        String jdkPath = IdeSdksConfigurable.getIdeJdkPath();
        String sdkPath = IdeSdksConfigurable.getIdeAndroidSdkPath();
        IdeSdks ideSdks = IdeSdks.getInstance();
        boolean validJdk = ideSdks.isUsingEmbeddedJdk() || !jdkPath.isEmpty() && JdkUtil.checkForJdk((File)new File(jdkPath));
        boolean validSdk = !sdkPath.isEmpty() && ideSdks.isValidAndroidSdkPath(new File(sdkPath));
        return !validJdk || !validSdk;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Object path;
        if (place != null && (path = place.getPath(SDKS_PLACE)) instanceof String) {
            Component c = (Component)this.myComponentsById.get(path);
            if (requestFocus && c != null) {
                c.requestFocusInWindow();
            }
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        place.putPath(SDKS_PLACE, (Object)this.mySelectedComponentId);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myWholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(14, 4, 4, 4), -1, 10, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html><b>Android SDK location:</b><br> This location will be used for new projects and for existing projects that do not have a local.properties file with a sdk.dir property.</html>");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.mySdkLocationTextField;
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, new Dimension(215, -1), null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html><b>JDK location:</b><br></html>");
        jPanel3.add((Component)jLabel2, new GridConstraints(4, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(5, 0, 1, 2, 0, 3, 6, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myJdkLocationComboBox;
        jPanel5.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myJdkWarningPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myJdkWarningLink;
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, new Dimension(4, 21), null));
        JLabel jLabel3 = this.myJdkWarningLabel;
        jLabel3.setText(JDK_LOCATION_WARNING);
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("<html><b>Android NDK location:</b><br> This location will be saved as ndk.dir property in the local.properties file.</html>");
        jPanel3.add((Component)jLabel4, new GridConstraints(2, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(3, 0, 1, 2, 0, 3, 6, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton2 = this.myNdkLocationComboBox;
        jPanel6.add((Component)comboboxWithBrowseButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 3, null, null, null));
        this.myNdkDownloadPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        HyperlinkLabel hyperlinkLabel2 = this.myNdkDownloadHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel2, "link");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, "loading");
        AsyncProcessIcon asyncProcessIcon = this.myNdkCheckProcessIcon;
        jPanel7.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Checking availability...");
        jPanel7.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    public static class LabelAndFileForLocation {
        @NotNull
        private String myLabel;
        @NotNull
        private File myFile;

        public LabelAndFileForLocation(@NotNull String label, @NotNull File file) {
            this.myLabel = label;
            this.myFile = file;
        }

        @NotNull
        public String getLabel() {
            return this.myLabel;
        }

        @NotNull
        public File getFile() {
            return this.myFile;
        }

        @NotNull
        public String getSystemDependentPath() {
            return FileUtilRt.toSystemDependentName((String)this.myFile.getPath());
        }

        public String toString() {
            return this.myLabel + ": " + this.getSystemDependentPath();
        }
    }
}

