/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.project;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.TargetAndroidModuleNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview.TargetModulesTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.GoToModuleAction;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseCollapseAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.NodeHyperlinkSupport;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

class TargetModulesPanel
extends ToolWindowPanel {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final Tree myTree;
    @NotNull
    private final TargetModulesTreeBuilder myTreeBuilder;
    @NotNull
    private final NodeHyperlinkSupport<TargetAndroidModuleNode> myHyperlinkSupport;

    TargetModulesPanel(@NotNull PsContext context) {
        super("Target Modules/Artifacts", AllIcons.Nodes.ModuleGroup, ToolWindowAnchor.RIGHT);
        this.myContext = context;
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree(treeModel){

            protected void processMouseEvent(MouseEvent e) {
                TargetAndroidModuleNode node;
                int id = e.getID();
                if (id == 501 && (node = (TargetAndroidModuleNode)((Object)TargetModulesPanel.this.myHyperlinkSupport.getIfHyperlink(e))) != null) {
                    PsAndroidModule module = (PsAndroidModule)node.getFirstModel();
                    String name = module.getName();
                    TargetModulesPanel.this.myContext.setSelectedModule(name, TargetModulesPanel.this);
                    return;
                }
                super.processMouseEvent(e);
            }
        };
        this.myTree.setRowHeight(JBUI.scale((int)24));
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                TargetModulesPanel.this.popupInvoked(x, y);
            }
        });
        this.setHeaderActions();
        this.getHeader().setPreferredFocusedComponent((JComponent)this.myTree);
        this.myTreeBuilder = new TargetModulesTreeBuilder((JTree)this.myTree, treeModel, context.getUiSettings());
        JScrollPane scrollPane = UiUtil.setUp(this.myTreeBuilder);
        this.add((Component)scrollPane, "Center");
        this.myHyperlinkSupport = new NodeHyperlinkSupport<TargetAndroidModuleNode>(this.myTree, TargetAndroidModuleNode.class, this.myContext, false);
    }

    private void setHeaderActions() {
        ArrayList additionalActions = Lists.newArrayList();
        additionalActions.add(new AbstractBaseCollapseAllAction(this.myTree){

            public void actionPerformed(@NotNull AnActionEvent e) {
                TargetModulesPanel.this.myTree.requestFocusInWindow();
                TargetModulesPanel.this.myTreeBuilder.collapseAllNodes();
            }
        });
        this.getHeader().setAdditionalActions(additionalActions);
    }

    private void popupInvoked(int x, int y) {
        TargetAndroidModuleNode node = this.myHyperlinkSupport.getNodeForLocation(x, y);
        if (node != null) {
            PsAndroidModule module = (PsAndroidModule)node.getFirstModel();
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new GoToModuleAction(module.getName(), this.myContext, (JComponent)this.myTree));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
            popupMenu.getComponent().show((Component)this.myTree, x, y);
        }
    }

    void displayTargetModules(@NotNull List<AbstractDependencyNode<? extends PsBaseDependency>> dependencyNodes) {
        this.myTreeBuilder.displayTargetModules(dependencyNodes);
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myTreeBuilder);
        Disposer.dispose(this.myHyperlinkSupport);
    }
}

