/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.dependencies.details;

import com.android.tools.idea.gradle.structure.configurables.dependencies.details.DependencyDetails;
import com.android.tools.idea.gradle.structure.model.PsDeclaredDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.intellij.openapi.ui.ComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

interface ConfigurationDependencyDetails
extends DependencyDetails {
    public JComboBox<String> getConfigurationUI();

    default public JComboBox<String> createConfigurationUI() {
        ComboBox ui = new ComboBox();
        ui.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationDependencyDetails.this.modifyConfiguration();
            }
        });
        return ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void displayConfiguration(@NotNull PsDeclaredDependency dependency, @NotNull PsModule.ImportantFor importantFor) {
        if (dependency != this.getModel()) {
            if (this.getModel() != null) {
                this.modifyConfiguration();
            }
            JComboBox<String> ui = this.getConfigurationUI();
            ActionListener[] listeners = ui.getActionListeners();
            try {
                for (ActionListener l : listeners) {
                    ui.removeActionListener(l);
                }
                ui.removeAllItems();
                String configuration = dependency.getJoinedConfigurationNames();
                for (String c : dependency.getParent().getConfigurations(importantFor)) {
                    ui.addItem(c);
                }
                ui.setSelectedItem(configuration);
            }
            finally {
                for (ActionListener l : listeners) {
                    ui.addActionListener(l);
                }
            }
        }
    }

    default public void modifyConfiguration() {
        PsDeclaredDependency dependency = (PsDeclaredDependency)this.getModel();
        String configuration = (String)this.getConfigurationUI().getEditor().getItem();
        if (dependency != null && configuration != null) {
            PsModule module = dependency.getParent();
            module.modifyDependencyConfiguration(dependency, configuration);
        }
    }
}

