/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.dependencies.details;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.ConfigurationDependencyDetails;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDeclaredModuleDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependencyDetails
implements ConfigurationDependencyDetails {
    @NotNull
    private final PsContext myContext;
    private final boolean myShowScope;
    private JPanel myMainPanel;
    private JXLabel myNameLabel;
    private JXLabel myGradlePathLabel;
    private JBLabel myScopePromptLabel;
    private HyperlinkLabel myGoToLabel;
    private JComboBox<String> myScope;
    private PsModuleDependency myDependency;

    public ModuleDependencyDetails(@NotNull PsContext context, boolean showScope) {
        this.myContext = context;
        this.myShowScope = showScope;
        this.$$$setupUI$$$();
        this.myScopePromptLabel.setVisible(showScope);
        this.myScope.setVisible(showScope);
        this.myGoToLabel.setHyperlinkText("See Dependencies");
        this.myGoToLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                assert (ModuleDependencyDetails.this.myDependency != null);
                ModuleDependencyDetails.this.myContext.getMainConfigurable().navigateTo(ModuleDependencyDetails.this.myContext.getProject().findModuleByGradlePath(ModuleDependencyDetails.this.myDependency.getGradlePath()).getPath().getDependenciesPath().getPlaceDestination(ModuleDependencyDetails.this.myContext), true);
            }
        });
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        return this.myMainPanel;
    }

    @Override
    public void display(@NotNull PsBaseDependency dependency) {
        PsModuleDependency d = (PsModuleDependency)dependency;
        this.myNameLabel.setText(d.getName());
        this.myGradlePathLabel.setText(d.getGradlePath());
        if (this.myShowScope) {
            this.displayConfiguration((PsDeclaredModuleDependency)d, PsModule.ImportantFor.MODULE);
        }
        this.myDependency = d;
    }

    @NotNull
    public Class<PsModuleDependency> getSupportedModelType() {
        return PsModuleDependency.class;
    }

    @Override
    @Nullable
    public PsModuleDependency getModel() {
        return this.myDependency;
    }

    @Override
    public JComboBox<String> getConfigurationUI() {
        return this.myScope;
    }

    private void createUIComponents() {
        this.myScope = this.createConfigurationUI();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        JBLabel jBLabel;
        JXLabel jXLabel;
        JXLabel jXLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setText("Name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel3.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel3.setText("Gradle Path:");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameLabel = jXLabel2 = new JXLabel();
        Font font = UIManager.getFont("Tree.font");
        if (font != null) {
            jXLabel2.setFont(font);
        }
        jPanel.add((Component)jXLabel2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myGradlePathLabel = jXLabel = new JXLabel();
        Font font2 = UIManager.getFont("Tree.font");
        if (font2 != null) {
            jXLabel.setFont(font2);
        }
        jPanel.add((Component)jXLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myScopePromptLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("Scope:");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGoToLabel = hyperlinkLabel = new HyperlinkLabel();
        Font font3 = UIManager.getFont("Tree.font");
        if (font3 != null) {
            hyperlinkLabel.setFont(font3);
        }
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JComboBox<String> jComboBox = this.myScope;
        jComboBox.setEditable(true);
        jComboBox.setName("scope");
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

