/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.dependencies.treeview;

import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.DependencyNodesKt;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.model.PsDeclaredDependency;
import com.android.tools.idea.gradle.structure.model.PsDeclaredModuleDependency;
import com.android.tools.idea.gradle.structure.model.PsDependencyCollection;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.android.tools.idea.gradle.structure.model.PsModuleDependencyKt;
import com.android.tools.idea.gradle.structure.model.PsResolvedModuleDependency;
import com.google.common.collect.Lists;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ModuleDependencyNode
extends AbstractDependencyNode<PsModuleDependency> {
    private final List<AbstractPsModelNode<?>> myChildren = Lists.newArrayList();

    public ModuleDependencyNode(@NotNull AbstractPsNode parent, @NotNull PsResolvedModuleDependency dependency) {
        super(parent, dependency);
        this.myName = dependency.toText();
        this.setUp(dependency);
    }

    public ModuleDependencyNode(@NotNull AbstractPsNode parent, @NotNull Collection<PsDeclaredModuleDependency> dependencies) {
        super(parent, dependencies.stream().map(it -> it).collect(Collectors.toList()));
        this.myName = ((PsModuleDependency)this.getFirstModel()).toText();
    }

    private void setUp(@NotNull PsResolvedModuleDependency moduleDependency) {
        PsDependencyCollection<?, ?, ?, ?> dependencies = PsModuleDependencyKt.getTargetModuleResolvedDependencies(moduleDependency);
        if (dependencies != null) {
            List<AbstractPsModelNode<?>> children = DependencyNodesKt.createNodesForResolvedDependencies(this, dependencies);
            this.myChildren.addAll(children);
        }
    }

    @NotNull
    public SimpleNode[] getChildren() {
        return this.myChildren.toArray(new SimpleNode[0]);
    }

    @Override
    public boolean matches(@NotNull PsModel model2) {
        if (model2 instanceof PsDeclaredDependency) {
            PsDeclaredDependency other = (PsDeclaredDependency)model2;
            List models = this.getModels();
            for (PsModuleDependency ourModel : models) {
                List<DependencyModel> ourParsedModels = Companion.getDependencyParsedModels(ourModel);
                if (ourParsedModels == null) continue;
                for (DependencyModel resolvedFromParsedDependency : ourParsedModels) {
                    if (!(other.getParsedModel() instanceof ModuleDependencyModel) || !(resolvedFromParsedDependency instanceof ModuleDependencyModel)) continue;
                    ModuleDependencyModel theirs = (ModuleDependencyModel)other.getParsedModel();
                    ModuleDependencyModel ours = (ModuleDependencyModel)resolvedFromParsedDependency;
                    return theirs.configurationName().equals(ours.configurationName()) && theirs.name().equals(ours.name());
                }
            }
        }
        return false;
    }
}

