/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.issues;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.GoToPathLinkHandler;
import com.android.tools.idea.gradle.structure.configurables.issues.InternetLinkHandler;
import com.android.tools.idea.gradle.structure.configurables.issues.LinkHandler;
import com.android.tools.idea.gradle.structure.configurables.issues.QuickFixLinkHandler;
import com.intellij.ui.HyperlinkAdapter;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class NavigationHyperlinkListener
extends HyperlinkAdapter {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final LinkHandler[] myHandlers;

    public NavigationHyperlinkListener(@NotNull PsContext context) {
        this(context, new QuickFixLinkHandler(context), new GoToPathLinkHandler(context), new InternetLinkHandler());
    }

    public NavigationHyperlinkListener(@NotNull PsContext context, LinkHandler ... handlers) {
        this.myContext = context;
        this.myHandlers = handlers;
    }

    protected void hyperlinkActivated(HyperlinkEvent e) {
        this.navigate(e.getDescription());
    }

    public void navigate(@NotNull String target) {
        for (LinkHandler handler : this.myHandlers) {
            if (!handler.accepts(target)) continue;
            handler.navigate(target);
            break;
        }
    }
}

