/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseModuleDialog
extends DialogWrapper {
    @NotNull
    private final Consumer<PsModule> myOnOkTask;
    private JPanel myPanel;
    private JBList myModuleList;

    public ChooseModuleDialog(@NotNull PsProject project, @NotNull Consumer<PsModule> onOkTask, @NotNull String title) {
        super(project.getIdeProject());
        this.myOnOkTask = onOkTask;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(title);
        DefaultListModel listModel = new DefaultListModel();
        project.forEachModule(listModel::addElement);
        this.myModuleList.setModel(listModel);
        this.myModuleList.setSelectionMode(0);
        this.myModuleList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
                if (c instanceof JLabel && value2 instanceof PsModule) {
                    PsModule module = (PsModule)value2;
                    JLabel label = (JLabel)c;
                    label.setText(module.getName());
                    label.setIcon(module.getIcon());
                }
                return c;
            }
        });
        if (!this.myModuleList.isEmpty()) {
            this.myModuleList.setSelectedIndex(0);
        }
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "psd.choose.module.panel.dimension";
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myModuleList;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.getSelectedModule() == null) {
            return new ValidationInfo("Please select a module", (JComponent)this.myModuleList);
        }
        return null;
    }

    protected void doOKAction() {
        super.doOKAction();
        PsModule selectedModule = this.getSelectedModule();
        assert (selectedModule != null);
        this.myOnOkTask.accept(selectedModule);
    }

    @Nullable
    private PsModule getSelectedModule() {
        Object selectedValue = this.myModuleList.getSelectedValue();
        return selectedValue instanceof PsModule ? (PsModule)selectedValue : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(350, 200));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Please select a module:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myModuleList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        JBLabel jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

