/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.DependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.ui.ChooseModuleDialog;
import com.android.tools.idea.gradle.structure.configurables.ui.EmptyPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.DependencyInfoPanel;
import com.android.tools.idea.gradle.structure.dependencies.AddJarDependencyDialog;
import com.android.tools.idea.gradle.structure.dependencies.AddLibraryDependencyDialog;
import com.android.tools.idea.gradle.structure.dependencies.AddModuleDependencyDialog;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.structure.dialog.Header;
import com.android.tools.idea.structure.dialog.TrackedConfigurableKt;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDependenciesPanel
extends JPanel
implements Place.Navigator,
Disposable {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final EmptyPanel myEmptyDetailsPanel;
    @NotNull
    private final DependencyInfoPanel myInfoPanel;
    @NotNull
    private final JScrollPane myInfoScrollPane;
    @NotNull
    private final Header myHeader;
    @NotNull
    private final JPanel myContentsPanel;
    @NotNull
    private final String myEmptyText;
    @NotNull
    private final List<DependencyDetails> myDependencyDetails = Lists.newArrayList();
    @Nullable
    private final PsModule myModule;
    private DependencyDetails myCurrentDependencyDetails;
    private History myHistory;
    private IssuesViewer myIssuesViewer;
    private AddLibraryDependencyAction myAddLibraryDependencyAction;
    private AddJarDependencyAction myAddJarDependencyAction;

    protected AbstractDependenciesPanel(@NotNull String title, @NotNull PsContext context, @Nullable PsModule module) {
        super(new BorderLayout());
        this.myContext = context;
        this.myModule = module;
        this.myEmptyText = String.format("Please select a dependency from the '%1$s' view", title);
        this.myEmptyDetailsPanel = new EmptyPanel(this.myEmptyText);
        this.myInfoPanel = new DependencyInfoPanel();
        this.myInfoScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myEmptyDetailsPanel, (int)20, (int)31);
        this.myInfoScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myHeader = new Header(title);
        this.add((Component)this.myHeader, "North");
        JBSplitter splitter = new JBSplitter(true, "psd.editable.dependencies.main.horizontal.splitter.proportion", 0.55f);
        this.myContentsPanel = new JPanel(new BorderLayout());
        this.myContentsPanel.setBorder((Border)new SideBorder(OnePixelDivider.BACKGROUND, 8));
        splitter.setFirstComponent((JComponent)this.myContentsPanel);
        splitter.setSecondComponent((JComponent)this.myInfoScrollPane);
        this.add((Component)splitter, "Center");
    }

    @NotNull
    public abstract JComponent getPreferredFocusedComponent();

    protected void addDetails(@NotNull DependencyDetails details) {
        this.myDependencyDetails.add(details);
    }

    protected void setIssuesViewer(@NotNull IssuesViewer issuesViewer) {
        this.myIssuesViewer = issuesViewer;
        this.myIssuesViewer.setShowEmptyText(false);
        this.myInfoPanel.setIssuesViewer(this.myIssuesViewer);
    }

    protected void displayIssues(@NotNull Collection<PsIssue> issues, @Nullable PsPath scope) {
        assert (this.myIssuesViewer != null);
        this.myIssuesViewer.display(issues, scope);
        this.myInfoPanel.revalidateAndRepaintPanel();
        ApplicationManager.getApplication().invokeLater(() -> this.myInfoScrollPane.getVerticalScrollBar().setValue(0));
    }

    protected void updateDetails(@Nullable PsBaseDependency selected) {
        if (selected != null) {
            this.myCurrentDependencyDetails = this.findDetails(selected);
            if (this.myCurrentDependencyDetails != null) {
                this.myInfoPanel.setDependencyDetails(this.myCurrentDependencyDetails);
                this.myInfoScrollPane.setViewportView(this.myInfoPanel.getPanel());
                this.myCurrentDependencyDetails.display(selected);
                return;
            }
        }
        this.myCurrentDependencyDetails = null;
        this.myInfoScrollPane.setViewportView(this.myEmptyDetailsPanel);
    }

    @Nullable
    private DependencyDetails findDetails(@NotNull PsBaseDependency selected) {
        for (DependencyDetails details : this.myDependencyDetails) {
            if (!details.getSupportedModelType().isInstance(selected)) continue;
            return details;
        }
        return null;
    }

    @Nullable
    protected DependencyDetails getCurrentDependencyDetails() {
        return this.myCurrentDependencyDetails;
    }

    @NotNull
    protected final JPanel createActionsPanel() {
        final JPanel actionsPanel = new JPanel(new BorderLayout());
        DefaultActionGroup actions2 = new DefaultActionGroup();
        DumbAwareAction addDependencyAction = new DumbAwareAction("Add Dependency", "", IconUtil.getAddIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AbstractPopupAction>(null, AbstractDependenciesPanel.this.getPopupActions()){

                    public Icon getIconFor(AbstractPopupAction action2) {
                        return action2.icon;
                    }

                    public boolean isMnemonicsNavigationEnabled() {
                        return true;
                    }

                    public PopupStep onChosen(AbstractPopupAction action2, boolean finalChoice) {
                        return this.doFinalStep(action2::execute);
                    }

                    @NotNull
                    public String getTextFor(AbstractPopupAction action2) {
                        return "&" + action2.index + "  " + action2.text;
                    }
                });
                popup2.show(new RelativePoint((Component)actionsPanel, new Point(0, actionsPanel.getHeight() - 1)));
            }
        };
        addDependencyAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("NewElement").getShortcutSet(), (JComponent)this.myContentsPanel);
        actions2.add((AnAction)addDependencyAction);
        List<AnAction> extraToolbarActions = this.getExtraToolbarActions(this.myContentsPanel);
        if (!extraToolbarActions.isEmpty()) {
            actions2.addSeparator();
            actions2.addAll(extraToolbarActions);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TOP", (ActionGroup)actions2, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        actionsPanel.add((Component)toolbarComponent, "Center");
        return actionsPanel;
    }

    @NotNull
    protected List<AnAction> getExtraToolbarActions(@NotNull JComponent focusComponent) {
        return Collections.emptyList();
    }

    @NotNull
    private List<AbstractPopupAction> getPopupActions() {
        if (this.myAddLibraryDependencyAction == null) {
            this.myAddLibraryDependencyAction = new AddLibraryDependencyAction();
        }
        if (this.myAddJarDependencyAction == null) {
            this.myAddJarDependencyAction = new AddJarDependencyAction();
        }
        ArrayList actions2 = Lists.newArrayList((Object[])new AbstractPopupAction[]{this.myAddLibraryDependencyAction, this.myAddJarDependencyAction});
        PsProject project = this.myContext.getProject();
        if (project.getModelCount() > 1) {
            actions2.add(new AddModuleDependencyAction());
        }
        return actions2;
    }

    @NotNull
    protected JPanel getContentsPanel() {
        return this.myContentsPanel;
    }

    @NotNull
    protected PsContext getContext() {
        return this.myContext;
    }

    @NotNull
    public Header getHeader() {
        return this.myHeader;
    }

    @NotNull
    public String getEmptyText() {
        return this.myEmptyText;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    @Nullable
    protected History getHistory() {
        return this.myHistory;
    }

    public void queryPlace(@NotNull Place place) {
        PsBaseDependency model2;
        String dependency = "";
        DependencyDetails details = this.getCurrentDependencyDetails();
        if (details != null && (model2 = details.getModel()) != null) {
            dependency = model2.toText();
        }
        this.putPath(place, dependency);
    }

    public void putPath(@NotNull Place place, @NotNull String dependency) {
        place.putPath(this.getPlaceName(), (Object)dependency);
    }

    @NotNull
    protected abstract String getPlaceName();

    private static abstract class AbstractPopupAction
    implements ActionListener {
        @NotNull
        final String text;
        @NotNull
        final Icon icon;
        final int index;

        AbstractPopupAction(@NotNull String text, @NotNull Icon icon2, int index) {
            this.text = text;
            this.icon = icon2;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.execute();
        }

        abstract void execute();
    }

    private abstract class AbstractAddDependencyAction
    extends AbstractPopupAction {
        @NotNull
        private final String myTitle;

        AbstractAddDependencyAction(@NotNull String title, @NotNull String text, Icon icon2, int index) {
            super(text, icon2, index);
            this.myTitle = title;
        }

        @Override
        void execute() {
            if (AbstractDependenciesPanel.this.myModule == null) {
                PsProject project = AbstractDependenciesPanel.this.myContext.getProject();
                int modelCount = project.getModelCount();
                if (modelCount == 1) {
                    Ref moduleRef = new Ref();
                    project.forEachModule(arg_0 -> ((Ref)moduleRef).set(arg_0));
                    PsModule module = (PsModule)moduleRef.get();
                    assert (module != null);
                    this.showAddDependencyDialog(module);
                    return;
                }
                Consumer<PsModule> onOkTask = this::showAddDependencyDialog;
                ChooseModuleDialog dialog2 = new ChooseModuleDialog(project, onOkTask, this.myTitle);
                dialog2.showAndGet();
                return;
            }
            this.showAddDependencyDialog(AbstractDependenciesPanel.this.myModule);
        }

        protected abstract void showAddDependencyDialog(@NotNull PsModule var1);
    }

    private class AddModuleDependencyAction
    extends AbstractAddDependencyAction {
        AddModuleDependencyAction() {
            super("Add Module Dependency", "Module Dependency", AllIcons.Nodes.Module, 3);
        }

        @Override
        protected void showAddDependencyDialog(@NotNull PsModule module) {
            AddModuleDependencyDialog dialog2 = new AddModuleDependencyDialog(module);
            if (dialog2.showAndGet()) {
                TrackedConfigurableKt.logUsagePsdAction(module.getParent().getIdeProject(), AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_DEPENDENCIES_ADD_MODULE);
                dialog2.addNewDependencies();
            }
        }
    }

    private class AddJarDependencyAction
    extends AbstractAddDependencyAction {
        AddJarDependencyAction() {
            super("Add Jar/Aar Dependency", "Jar Dependency", PlatformIcons.JAR_ICON, 2);
        }

        @Override
        protected void showAddDependencyDialog(@NotNull PsModule module) {
            AddJarDependencyDialog dialog2 = new AddJarDependencyDialog(module);
            if (dialog2.showAndGet()) {
                TrackedConfigurableKt.logUsagePsdAction(module.getParent().getIdeProject(), AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_DEPENDENCIES_ADD_JAR);
                dialog2.addNewDependencies();
            }
        }
    }

    private class AddLibraryDependencyAction
    extends AbstractAddDependencyAction {
        AddLibraryDependencyAction() {
            super("Add Library Dependency", "Library Dependency", PlatformIcons.LIBRARY_ICON, 1);
        }

        @Override
        protected void showAddDependencyDialog(@NotNull PsModule module) {
            AddLibraryDependencyDialog dialog2 = new AddLibraryDependencyDialog(AbstractDependenciesPanel.this.myContext, module);
            if (dialog2.showAndGet()) {
                TrackedConfigurableKt.logUsagePsdAction(module.getParent().getIdeProject(), AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_DEPENDENCIES_ADD_LIBRARY);
                dialog2.addNewDependencies();
            }
        }
    }
}

