/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.gradle.structure.configurables.RepositorySearchFactory;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.model.PsDeclaredLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryKey;
import com.android.tools.idea.gradle.structure.model.PsLibraryKeyKt;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepositorySearchService;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchQuery;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResultKt;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003)*+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0001\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\"\u001a\u00020\u001fH\u0016J\u0006\u0010#\u001a\u00020\u001fJ$\u0010$\u001a\u00020\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0&H\u0003R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0015X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;", "Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/android/tools/idea/gradle/structure/model/PsProject;", "repositorySearchFactory", "Lcom/android/tools/idea/gradle/structure/configurables/RepositorySearchFactory;", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/gradle/structure/model/PsProject;Lcom/android/tools/idea/gradle/structure/configurables/RepositorySearchFactory;)V", "availableLibraryUpdateStorage", "Lcom/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage;", "getAvailableLibraryUpdateStorage", "()Lcom/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage;", "beingSearchedKeys", "", "Lcom/android/tools/idea/gradle/structure/model/PsLibraryKey;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$AvailableUpdatesListener;", "kotlin.jvm.PlatformType", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "resultsUpdaterQueue", "getResultsUpdaterQueue", "runningLock", "Ljava/util/concurrent/locks/Lock;", "runningSearches", "Ljava/util/concurrent/Future;", "add", "", "listener", "Lkotlin/Function0;", "dispose", "queueUpdateCheck", "search", "repositories", "", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepository;", "keys", "AvailableUpdatesListener", "RefreshAvailableUpdates", "UpdatesAvailable", "intellij.android.core"})
public final class PsLibraryUpdateCheckerDaemon
extends PsDaemon {
    @NotNull
    private final AvailableLibraryUpdateStorage availableLibraryUpdateStorage;
    @NotNull
    private final MergingUpdateQueue mainQueue;
    @NotNull
    private final MergingUpdateQueue resultsUpdaterQueue;
    private final EventDispatcher<AvailableUpdatesListener> eventDispatcher;
    private final Set<PsLibraryKey> beingSearchedKeys;
    private final Set<Future<?>> runningSearches;
    private final Lock runningLock;
    private final PsProject project;
    private final RepositorySearchFactory repositorySearchFactory;

    @NotNull
    public final AvailableLibraryUpdateStorage getAvailableLibraryUpdateStorage() {
        return this.availableLibraryUpdateStorage;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.mainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.resultsUpdaterQueue;
    }

    public final void queueUpdateCheck() {
        this.getMainQueue().queue((Update)new RefreshAvailableUpdates());
    }

    public final void add(@UiThread @NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        this.eventDispatcher.addListener((EventListener)new AvailableUpdatesListener(listener2){
            final /* synthetic */ Function0 $listener;

            public void availableUpdates() {
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        }, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Lock lock = this.runningLock;
        lock.lock();
        try {
            boolean bl = false;
            Iterable $receiver$iv = this.runningSearches;
            for (Object element$iv : $receiver$iv) {
                Future it = (Future)element$iv;
                boolean bl2 = false;
                it.cancel(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Slow
    private final void search(Collection<? extends ArtifactRepository> repositories, Collection<PsLibraryKey> keys) {
        void $receiver$iv$iv;
        Object future2;
        Iterable $receiver$iv;
        void $receiver$iv2;
        PsLibraryKey psLibraryKey;
        Object object;
        void $receiver$iv$iv2;
        void $receiver$iv3;
        AvailableLibraryUpdateStorage updateStorage = this.availableLibraryUpdateStorage;
        long currentTimeMillis = System.currentTimeMillis();
        Iterable iterable = updateStorage.retainAll((Function1<? super AvailableLibraryUpdateStorage.AvailableLibraryUpdate, Boolean>)((Function1)new Function1<AvailableLibraryUpdateStorage.AvailableLibraryUpdate, Boolean>(currentTimeMillis, keys){
            final /* synthetic */ long $currentTimeMillis;
            final /* synthetic */ Collection $keys;

            public final boolean invoke(@NotNull AvailableLibraryUpdateStorage.AvailableLibraryUpdate it) {
                long searchTimeMillis = it.getLastSearchTimeMillis();
                return searchTimeMillis > 0L && TimeUnit.MILLISECONDS.toDays(this.$currentTimeMillis - searchTimeMillis) < (long)3 && this.$keys.contains(it.toLibraryKey());
            }
            {
                this.$currentTimeMillis = l;
                this.$keys = collection;
                super(1);
            }
        }));
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10)), (int)16);
        void var9_8 = $receiver$iv3;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv22);
        for (Object element$iv$iv : $receiver$iv$iv2) {
            AvailableLibraryUpdateStorage.AvailableLibraryUpdate availableLibraryUpdate = (AvailableLibraryUpdateStorage.AvailableLibraryUpdate)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            psLibraryKey = availableLibraryUpdate.toLibraryKey();
            object.put(psLibraryKey, element$iv$iv);
        }
        Map existingUpdateKeys2 = destination$iv$iv;
        Iterable capacity$iv22 = keys;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            PsLibraryKey psLibraryKey2 = (PsLibraryKey)element$iv$iv;
            boolean bl = false;
            if (!(!existingUpdateKeys2.containsKey(psLibraryKey2) && this.beingSearchedKeys.add(psLibraryKey2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set requests = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        ArtifactRepositorySearchService searcher = this.repositorySearchFactory.create(repositories);
        destination$iv$iv = this.runningLock;
        destination$iv$iv.lock();
        try {
            boolean bl = false;
            if (this.isStopped()) {
                return;
            }
            Iterable iterable2 = $receiver$iv = (Iterable)requests;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object t : iterable2) {
                void key;
                PsLibraryKey psLibraryKey3 = (PsLibraryKey)t;
                Collection collection2 = collection;
                boolean bl2 = false;
                future2 = searcher.search(new SearchRequest(new SearchQuery(key.getGroup(), key.getName()), 1, 0));
                this.runningSearches.add((Future<?>)future2);
                Pair pair = TuplesKt.to((Object)key, future2);
                collection2.add(pair);
            }
            $receiver$iv = (List)collection;
        }
        finally {
            destination$iv$iv.unlock();
        }
        Iterable resultFutures = $receiver$iv;
        Object $receiver$iv4 = resultFutures;
        $receiver$iv = $receiver$iv4;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
        for (Object t : $receiver$iv$iv) {
            Pair pair = (Pair)t;
            object = collection;
            boolean bl = false;
            psLibraryKey = TuplesKt.to((Object)pair.getFirst(), (Object)SearchResultKt.getResultSafely((Future)pair.getSecond()));
            object.add(psLibraryKey);
        }
        List searchResults = (List)collection;
        $receiver$iv4 = this.runningLock;
        $receiver$iv4.lock();
        try {
            boolean bl = false;
            Iterable iterable3 = resultFutures;
            Set<Future<?>> set = this.runningSearches;
            Iterable iterable4 = iterable3;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
            for (Object item$iv$iv : iterable4) {
                void it;
                Pair $i$f$map = (Pair)item$iv$iv;
                future2 = collection3;
                boolean bl3 = false;
                ListenableFuture $i$f$mapTo = (ListenableFuture)it.getSecond();
                future2.add((ListenableFuture)$i$f$mapTo);
            }
            future2 = (List)collection3;
            boolean bl4 = set.removeAll((Collection)future2);
        }
        finally {
            $receiver$iv4.unlock();
        }
        Iterable bl = searchResults;
        void var13_27 = $receiver$iv;
        Collection collection4 = new ArrayList();
        for (Object t : var13_27) {
            Pair it = (Pair)t;
            boolean bl5 = false;
            Object object2 = (SearchResult)it.getSecond();
            if (object2 == null || (object2 = ((SearchResult)object2).getArtifacts()) == null || (object2 = UtilKt.nullize((List)object2)) == null) {
                PsLibraryUpdateCheckerDaemon psLibraryUpdateCheckerDaemon;
                PsLibraryUpdateCheckerDaemon $receiver = psLibraryUpdateCheckerDaemon = this;
                boolean bl6 = false;
                PsLibraryKey key = (PsLibraryKey)it.getFirst();
                SearchResult result2 = (SearchResult)it.getSecond();
                Object object3 = result2;
                if (object3 != null && (object3 = ((SearchResult)object3).getErrors()) != null && object3.isEmpty()) {
                    String string = key.getName();
                    String string2 = key.getGroup();
                    String string3 = "";
                    List list = CollectionsKt.emptyList();
                    Collection collection5 = list;
                    String string4 = string;
                    String string5 = string2;
                    String string6 = string3;
                    object2 = CollectionsKt.listOf((Object)new FoundArtifact(string6, string5, string4, collection5));
                } else {
                    object2 = CollectionsKt.emptyList();
                }
            }
            Iterable list$iv$iv = (Iterable)object2;
            CollectionsKt.addAll((Collection)collection4, (Iterable)list$iv$iv);
        }
        List foundArtifacts = (List)collection4;
        $receiver$iv = searchResults;
        for (Object t : $receiver$iv) {
            Pair pair = (Pair)t;
            boolean bl7 = false;
            this.beingSearchedKeys.remove(pair.getFirst());
        }
        $receiver$iv = foundArtifacts;
        Iterator iterator = $receiver$iv.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
                return;
            }
            Object t = iterator.next();
            FoundArtifact foundArtifact = (FoundArtifact)t;
            boolean bl8 = false;
            updateStorage.addOrUpdate(foundArtifact, currentTimeMillis);
        }
    }

    public PsLibraryUpdateCheckerDaemon(@NotNull Disposable parentDisposable, @NotNull PsProject project, @NotNull RepositorySearchFactory repositorySearchFactory) {
        super(parentDisposable);
        Set set;
        this.project = project;
        this.repositorySearchFactory = repositorySearchFactory;
        this.availableLibraryUpdateStorage = AvailableLibraryUpdateStorage.Companion.getInstance(this.project.getIdeProject());
        this.mainQueue = this.createQueue("Project Structure Daemon Update Checker", null);
        this.resultsUpdaterQueue = this.createQueue("Project Structure Available Update Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        this.eventDispatcher = EventDispatcher.create(AvailableUpdatesListener.class);
        this.beingSearchedKeys = ContainerUtil.newConcurrentSet();
        PsLibraryUpdateCheckerDaemon psLibraryUpdateCheckerDaemon = this;
        psLibraryUpdateCheckerDaemon.runningSearches = set = (Set)new LinkedHashSet();
        this.runningLock = new ReentrantLock();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$RefreshAvailableUpdates;", "Lcom/intellij/util/ui/update/Update;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "run", "", "intellij.android.core"})
    private final class RefreshAvailableUpdates
    extends Update {
        public void run() {
            Set repositories = new LinkedHashSet();
            Set keys = new LinkedHashSet();
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(this, repositories, keys){
                final /* synthetic */ RefreshAvailableUpdates this$0;
                final /* synthetic */ Set $repositories;
                final /* synthetic */ Set $keys;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    Iterable $receiver$iv = PsLibraryUpdateCheckerDaemon.access$getProject$p(this.this$0.PsLibraryUpdateCheckerDaemon.this).getModules();
                    for (T element$iv : $receiver$iv) {
                        Collection<PsLibraryKey> collection;
                        void $receiver$iv$iv;
                        void $receiver$iv2;
                        PsModule module = (PsModule)element$iv;
                        boolean bl = false;
                        this.$repositories.addAll(module.getArtifactRepositories());
                        Iterable iterable = module.getDependencies().getLibraries();
                        Set set = this.$keys;
                        void var8_8 = $receiver$iv2;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            PsDeclaredLibraryDependency psDeclaredLibraryDependency = (PsDeclaredLibraryDependency)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            PsLibraryKey psLibraryKey = PsLibraryKeyKt.toLibraryKey(it.getSpec());
                            collection.add(psLibraryKey);
                        }
                        collection = (List)destination$iv$iv;
                        set.addAll((Collection)collection);
                    }
                }
                {
                    this.this$0 = refreshAvailableUpdates;
                    this.$repositories = set;
                    this.$keys = set2;
                    super(0);
                }
            }));
            if (!repositories.isEmpty() && !keys.isEmpty()) {
                PsLibraryUpdateCheckerDaemon.this.search(repositories, keys);
            } else {
                PsLibraryUpdateCheckerDaemon.this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
            }
        }

        public RefreshAvailableUpdates() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.project);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$UpdatesAvailable;", "Lcom/intellij/util/ui/update/Update;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "run", "", "intellij.android.core"})
    private final class UpdatesAvailable
    extends Update {
        @UiThread
        public void run() {
            ((AvailableUpdatesListener)PsLibraryUpdateCheckerDaemon.this.eventDispatcher.getMulticaster()).availableUpdates();
        }

        public UpdatesAvailable() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.project);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$AvailableUpdatesListener;", "Ljava/util/EventListener;", "availableUpdates", "", "intellij.android.core"})
    private static interface AvailableUpdatesListener
    extends EventListener {
        @UiThread
        public void availableUpdates();
    }
}

