/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u001a,\u0010\f\u001a\u001c\u0012\u0004\u0012\u00020\u000e\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00060\u00060\u000f0\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"URL_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "createIssueFrom", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "syncIssue", "Lcom/android/builder/model/SyncIssue;", "path", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "getSeverity", "Lcom/android/tools/idea/gradle/structure/model/PsIssue$Severity;", "issue", "transferSyncIssues", "", "", "", "gradleModel", "Lcom/android/tools/idea/gradle/project/model/AndroidModuleModel;", "intellij.android.core"})
public final class PsAndroidModuleAnalyzerKt {
    private static final Pattern URL_PATTERN = Pattern.compile("\\(?http://[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]");

    @VisibleForTesting
    @NotNull
    public static final PsIssue createIssueFrom(@NotNull SyncIssue syncIssue, @NotNull PsPath path) {
        String message2 = XmlStringUtil.escapeString((String)syncIssue.getMessage());
        Matcher matcher = URL_PATTERN.matcher(message2);
        boolean result2 = matcher.find();
        while (result2) {
            String url = matcher.group();
            message2 = StringsKt.replace$default((String)message2, (String)url, (String)("<a href='" + url + "'>" + url + "</a>"), (boolean)false, (int)4, null);
            result2 = matcher.find();
        }
        return new PsGeneralIssue(message2, path, PsIssueType.PROJECT_ANALYSIS, PsAndroidModuleAnalyzerKt.getSeverity(syncIssue), null, 16, null);
    }

    private static final PsIssue.Severity getSeverity(SyncIssue issue2) {
        int severity = issue2.getSeverity();
        switch (severity) {
            case 2: {
                return PsIssue.Severity.ERROR;
            }
            case 1: {
                return PsIssue.Severity.WARNING;
            }
        }
        return PsIssue.Severity.INFO;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, List<SyncIssue>> transferSyncIssues(AndroidModuleModel gradleModel) {
        Map map2;
        Map map3;
        Map map4;
        Object object = gradleModel;
        if (object != null && (object = ((AndroidModuleModel)object).getAndroidProject()) != null && (object = object.getSyncIssues()) != null) {
            void var3_3;
            SyncIssue it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)object;
            Object destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (SyncIssue)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it.getData();
                if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Object object2;
                String key$iv$iv;
                Object $receiver$iv$iv$iv;
                Object value$iv$iv$iv;
                it = (SyncIssue)element$iv$iv;
                boolean bl = false;
                if (it.getData() == null) {
                    Intrinsics.throwNpe();
                }
                if ((value$iv$iv$iv = ($receiver$iv$iv$iv = destination$iv$iv).get(key$iv$iv)) == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            map4 = var3_3;
        } else {
            map4 = null;
        }
        if ((map3 = (map2 = map4)) == null) {
            map3 = MapsKt.emptyMap();
        }
        return map3;
    }

    public static final /* synthetic */ Map access$transferSyncIssues(AndroidModuleModel gradleModel) {
        return PsAndroidModuleAnalyzerKt.transferSyncIssues(gradleModel);
    }
}

