/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.tools.idea.gradle.structure.daemon.analysis.PsModuleAnalyzerKt;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModuleAnalyzerKt$WhenMappings;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDeclaredDependency;
import com.android.tools.idea.gradle.structure.model.PsDeclaredLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsQuickFix;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsDependencyScopeQuickFixPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyPlusQuickFixPath;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"analyzeDeclaredDependency", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "dependency", "Lcom/android/tools/idea/gradle/structure/model/PsDeclaredLibraryDependency;", "analyzeDependencyScope", "", "Lcom/android/tools/idea/gradle/structure/model/PsDeclaredDependency;", "intellij.android.core"})
public final class PsModuleAnalyzerKt {
    @NotNull
    public static final Sequence<PsIssue> analyzeDeclaredDependency(@NotNull PsDeclaredLibraryDependency dependency) {
        PsLibraryDependencyNavigationPath path = dependency.getPath();
        PsArtifactDependencySpec declaredSpec = dependency.getSpec();
        String declaredVersion = declaredSpec.getVersion();
        if (declaredVersion != null && StringsKt.endsWith$default((String)declaredVersion, (String)"+", (boolean)false, (int)2, null)) {
            String message2 = "Avoid using '+' in version numbers; can lead to unpredictable and unrepeatable builds.";
            PsGeneralIssue issue2 = new PsGeneralIssue(message2, path, PsIssueType.PROJECT_ANALYSIS, PsIssue.Severity.WARNING, new PsLibraryDependencyPlusQuickFixPath(dependency));
            return SequencesKt.sequenceOf((Object[])new PsGeneralIssue[]{issue2});
        }
        return SequencesKt.emptySequence();
    }

    @NotNull
    public static final Iterable<PsIssue> analyzeDependencyScope(@NotNull PsDeclaredDependency dependency) {
        Function0<Boolean> shouldSuggestApiScopeReplacement$ = new Function0<Boolean>(dependency){
            final /* synthetic */ PsDeclaredDependency $dependency;

            public final boolean invoke() {
                boolean bl;
                if (StringsKt.startsWith$default((String)this.$dependency.getConfigurationName(), (String)"test", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.$dependency.getConfigurationName(), (String)"androidTest", (boolean)false, (int)2, null)) {
                    return false;
                }
                PsModule module = this.$dependency.getParent();
                switch (PsModuleAnalyzerKt$WhenMappings.$EnumSwitchMapping$0[module.getProjectType().ordinal()]) {
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = false;
                        break;
                    }
                    case 3: {
                        bl = true;
                        break;
                    }
                    case 4: {
                        bl = false;
                        break;
                    }
                    case 5: {
                        bl = true;
                        break;
                    }
                    case 6: {
                        bl = true;
                        break;
                    }
                    case 7: {
                        bl = false;
                        break;
                    }
                    case 8: {
                        bl = true;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return bl;
            }
            {
                this.$dependency = psDeclaredDependency;
                super(0);
            }
        };
        Function1<String, List<? extends PsQuickFix>> fixesFor$ = new Function1<String, List<? extends PsQuickFix>>(shouldSuggestApiScopeReplacement$, dependency){
            final /* synthetic */ analyzeDependencyScope.1 $shouldSuggestApiScopeReplacement$1;
            final /* synthetic */ PsDeclaredDependency $dependency;

            @NotNull
            public final List<PsQuickFix> invoke(@NotNull String configurationName) {
                boolean suggestApi = this.$shouldSuggestApiScopeReplacement$1.invoke();
                String implementationReplacement = null;
                String apiReplacement = null;
                if (Intrinsics.areEqual((Object)configurationName, (Object)"compile")) {
                    implementationReplacement = "implementation";
                    apiReplacement = "api";
                } else {
                    implementationReplacement = StringsKt.removeSuffix((String)configurationName, (CharSequence)"Compile") + "Implementation";
                    apiReplacement = StringsKt.removeSuffix((String)configurationName, (CharSequence)"Compile") + "Api";
                }
                PsDependencyScopeQuickFixPath implementationFix = new PsDependencyScopeQuickFixPath(this.$dependency, implementationReplacement);
                return suggestApi ? CollectionsKt.listOf((Object[])new PsDependencyScopeQuickFixPath[]{new PsDependencyScopeQuickFixPath(this.$dependency, apiReplacement), implementationFix}) : CollectionsKt.listOf((Object)implementationFix);
            }
            {
                this.$shouldSuggestApiScopeReplacement$1 = var1_1;
                this.$dependency = psDeclaredDependency;
                super(1);
            }
        };
        List issues = new ArrayList();
        String configurationName = dependency.getConfigurationName();
        if (Intrinsics.areEqual((Object)configurationName, (Object)"compile") || StringsKt.endsWith$default((String)configurationName, (String)"Compile", (boolean)false, (int)2, null)) {
            String text = "Obsolete scope found: <b>" + configurationName + "</b>";
            List<PsQuickFix> fixes = fixesFor$.invoke(configurationName);
            PsPath path = dependency.getPath();
            if (path != null) {
                PsGeneralIssue issue2 = new PsGeneralIssue(text, "", path, PsIssueType.PROJECT_ANALYSIS, PsIssue.Severity.WARNING, fixes);
                issues.add(issue2);
            }
        }
        Iterable iterable = issues;
        return iterable;
    }
}

