/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.structure.editors.MavenDependencyLookupDialog;
import com.android.tools.idea.gradle.structure.editors.ModuleDependenciesTableItem;
import com.android.tools.idea.gradle.structure.editors.ModuleDependenciesTableModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.structure.EditorPanel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependenciesPanel
extends EditorPanel {
    private static final Logger LOG = Logger.getInstance(ModuleDependenciesPanel.class);
    private static final int SCOPE_COLUMN_WIDTH = 120;
    private final JBTable myEntryTable;
    private final ModuleDependenciesTableModel myModel;
    private final String myModulePath;
    private final Project myProject;
    private final GradleBuildFile myGradleBuildFile;
    private final GradleSettingsFile myGradleSettingsFile;
    private AnActionButton myRemoveButton;

    public ModuleDependenciesPanel(@NotNull Project project, @NotNull String modulePath) {
        super(new BorderLayout());
        this.myModulePath = modulePath;
        this.myProject = project;
        this.myModel = new ModuleDependenciesTableModel();
        this.myGradleSettingsFile = GradleSettingsFile.get(this.myProject);
        Module module = GradleUtil.findModuleByGradlePath(this.myProject, modulePath);
        GradleBuildFile gradleBuildFile = this.myGradleBuildFile = module != null ? GradleBuildFile.get(module) : null;
        if (this.myGradleBuildFile != null) {
            List<BuildFileStatement> dependencies = this.myGradleBuildFile.getDependencies();
            for (BuildFileStatement dependency : dependencies) {
                this.myModel.addItem(new ModuleDependenciesTableItem(dependency));
            }
        } else {
            LOG.warn("Unable to find Gradle build file for module " + this.myModulePath);
        }
        this.myModel.resetModified();
        this.myEntryTable = new JBTable((TableModel)this.myModel);
        TableRowSorter<ModuleDependenciesTableModel> sorter = new TableRowSorter<ModuleDependenciesTableModel>(this.myModel);
        sorter.setRowFilter(this.myModel.getFilter());
        this.myEntryTable.setRowSorter(sorter);
        this.myEntryTable.setShowGrid(false);
        this.myEntryTable.setDragEnabled(false);
        this.myEntryTable.setIntercellSpacing(new Dimension(0, 0));
        this.myEntryTable.setDefaultRenderer(ModuleDependenciesTableItem.class, (TableCellRenderer)((Object)new TableItemRenderer()));
        if (this.myGradleBuildFile == null) {
            return;
        }
        boolean isAndroid = this.myGradleBuildFile.hasAndroidPlugin();
        boolean compat = GradleUtil.useCompatibilityConfigurationNames(project);
        ArrayList scopes = Lists.newArrayList((Iterable)Sets.filter(EnumSet.allOf(Dependency.Scope.class), input -> input != null && compat == input.isCompat() && (isAndroid ? input.isAndroidScope() : input.isJavaScope())));
        CollectionComboBoxModel boxModel = new CollectionComboBoxModel((List)scopes, null);
        ComboBox scopeEditor = new ComboBox((ComboBoxModel)boxModel);
        this.myEntryTable.setDefaultEditor(Dependency.Scope.class, (TableCellEditor)new DefaultCellEditor((JComboBox<?>)scopeEditor));
        this.myEntryTable.setDefaultRenderer(Dependency.Scope.class, (TableCellRenderer)new ComboBoxTableRenderer<Dependency.Scope>(Dependency.Scope.values()){

            protected String getTextFor(@NotNull Dependency.Scope value2) {
                return value2.getDisplayName();
            }
        });
        this.myEntryTable.getSelectionModel().setSelectionMode(2);
        new SpeedSearchBase<JBTable>(this.myEntryTable){

            public int getSelectedIndex() {
                return ModuleDependenciesPanel.this.myEntryTable.getSelectedRow();
            }

            protected int convertIndexToModel(int viewIndex) {
                return ModuleDependenciesPanel.this.myEntryTable.convertRowIndexToModel(viewIndex);
            }

            @NotNull
            public Object[] getAllElements() {
                return ModuleDependenciesPanel.this.myModel.getItems().toArray();
            }

            @NotNull
            public String getElementText(Object element) {
                return ModuleDependenciesPanel.getCellAppearance((ModuleDependenciesTableItem)element).getText();
            }

            public void selectElement(@NotNull Object element, @NotNull String selectedText) {
                int count = ModuleDependenciesPanel.this.myModel.getRowCount();
                for (int row = 0; row < count; ++row) {
                    if (!element.equals(ModuleDependenciesPanel.this.myModel.getItemAt(row))) continue;
                    int viewRow = ModuleDependenciesPanel.this.myEntryTable.convertRowIndexToView(row);
                    ModuleDependenciesPanel.this.myEntryTable.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                    TableUtil.scrollSelectionToVisible((JTable)ModuleDependenciesPanel.this.myEntryTable);
                    break;
                }
            }
        };
        TableColumn column = this.myEntryTable.getTableHeader().getColumnModel().getColumn(1);
        column.setResizable(false);
        column.setMaxWidth(120);
        column.setMinWidth(120);
        this.add((Component)this.createTableWithButtons(), "Center");
        if (this.myEntryTable.getRowCount() > 0) {
            this.myEntryTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)this.myRemoveButton);
        PopupHandler.installPopupHandler((JComponent)this.myEntryTable, (ActionGroup)actionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    @NotNull
    private JComponent createTableWithButtons() {
        this.myEntryTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateButtons();
        });
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myEntryTable);
        decorator.setAddAction(button2 -> {
            ImmutableList popupActions = ImmutableList.of((Object)new PopupAction(StudioIcons.Shell.Filetree.MAVEN, 1, "Library dependency"){

                @Override
                public void run() {
                    ModuleDependenciesPanel.this.addExternalDependency();
                }
            }, (Object)new PopupAction(StudioIcons.Shell.Filetree.LIBRARY_MODULE, 2, "Jar dependency"){

                @Override
                public void run() {
                    ModuleDependenciesPanel.this.addFileDependency();
                }
            }, (Object)new PopupAction(StudioIcons.Shell.Filetree.ANDROID_MODULE, 3, "Module dependency"){

                @Override
                public void run() {
                    ModuleDependenciesPanel.this.addModuleDependency();
                }
            });
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PopupAction>(null, (List)popupActions){

                public Icon getIconFor(PopupAction value2) {
                    return value2.myIcon;
                }

                public boolean hasSubstep(PopupAction value2) {
                    return false;
                }

                public boolean isMnemonicsNavigationEnabled() {
                    return true;
                }

                public PopupStep onChosen(PopupAction value2, boolean finalChoice) {
                    return this.doFinalStep(value2);
                }

                @NotNull
                public String getTextFor(PopupAction value2) {
                    return "&" + value2.myIndex + "  " + value2.myTitle;
                }
            });
            popup2.show(button2.getPreferredPopupPoint());
        });
        decorator.setRemoveAction(button2 -> this.removeSelectedItems());
        decorator.setMoveUpAction(button2 -> this.moveSelectedRows(-1));
        decorator.setMoveDownAction(button2 -> this.moveSelectedRows(1));
        JPanel panel2 = decorator.createPanel();
        this.myRemoveButton = ToolbarDecorator.findRemoveButton((JComponent)panel2);
        return panel2;
    }

    private void addExternalDependency() {
        Module module = GradleUtil.findModuleByGradlePath(this.myProject, this.myModulePath);
        MavenDependencyLookupDialog dialog2 = new MavenDependencyLookupDialog(this.myProject, module);
        dialog2.setTitle("Choose Library Dependency");
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            String coordinateText = dialog2.getSearchText();
            Dependency.Scope scope = Dependency.Scope.getDefaultScope(this.myProject);
            this.myModel.addItem(new ModuleDependenciesTableItem(new Dependency(scope, Dependency.Type.EXTERNAL, coordinateText)));
        }
        this.myModel.fireTableDataChanged();
    }

    private void addFileDependency() {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, false, true, true, false, false);
        VirtualFile buildFile = this.myGradleBuildFile.getFile();
        VirtualFile parent = buildFile.getParent();
        descriptor2.setRoots(new VirtualFile[]{parent});
        VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)this.myProject, null);
        if (virtualFile != null) {
            String path = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)parent, (char)'/');
            if (path == null) {
                path = virtualFile.getPath();
            }
            Dependency.Scope scope = Dependency.Scope.getDefaultScope(this.myProject);
            this.myModel.addItem(new ModuleDependenciesTableItem(new Dependency(scope, Dependency.Type.FILES, path)));
        }
        this.myModel.fireTableDataChanged();
    }

    private void addModuleDependency() {
        ArrayList modules = Lists.newArrayList();
        for (String string : this.myGradleSettingsFile.getModules()) {
            modules.add(string);
        }
        List<BuildFileStatement> dependencies = this.myGradleBuildFile.getDependencies();
        for (BuildFileStatement dependency : dependencies) {
            Object data;
            if (!(dependency instanceof Dependency) || !((data = ((Dependency)dependency).data) instanceof String)) continue;
            modules.remove(data);
        }
        modules.remove(this.myModulePath);
        ModuleDependenciesPanel moduleDependenciesPanel = this;
        String title = ProjectBundle.message((String)"classpath.chooser.title.add.module.dependency", (Object[])new Object[0]);
        String description = ProjectBundle.message((String)"classpath.chooser.description.add.module.dependency", (Object[])new Object[0]);
        ChooseElementsDialog<String> dialog2 = new ChooseElementsDialog<String>((Component)moduleDependenciesPanel, (List)modules, title, description, true){

            protected Icon getItemIcon(String item) {
                return StudioIcons.Shell.Filetree.ANDROID_MODULE;
            }

            protected String getItemText(String item) {
                return item;
            }
        };
        dialog2.show();
        Dependency.Scope scope = Dependency.Scope.getDefaultScope(this.myProject);
        for (String module : dialog2.getChosenElements()) {
            this.myModel.addItem(new ModuleDependenciesTableItem(new Dependency(scope, Dependency.Type.MODULE, module)));
        }
        this.myModel.fireTableDataChanged();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateButtons();
    }

    private void updateButtons() {
        int[] selectedRows = this.myEntryTable.getSelectedRows();
        boolean removeButtonEnabled = true;
        int minRow = this.myEntryTable.getRowCount() + 1;
        int maxRow = -1;
        for (int selectedRow : selectedRows) {
            minRow = Math.min(minRow, selectedRow);
            maxRow = Math.max(maxRow, selectedRow);
            ModuleDependenciesTableItem item = this.myModel.getItemAt(selectedRow);
            if (item.isRemovable()) continue;
            removeButtonEnabled = false;
        }
        if (this.myRemoveButton != null) {
            this.myRemoveButton.setEnabled(removeButtonEnabled && selectedRows.length > 0);
        }
    }

    private void removeSelectedItems() {
        if (this.myEntryTable.isEditing()) {
            this.myEntryTable.getCellEditor().stopCellEditing();
        }
        for (int modelRow = this.myModel.getRowCount() - 1; modelRow >= 0; --modelRow) {
            if (!this.myEntryTable.isCellSelected(this.myEntryTable.convertRowIndexToView(modelRow), 0)) continue;
            this.myModel.removeDataRow(modelRow);
        }
        this.myModel.fireTableDataChanged();
        this.myModel.setModified();
    }

    private void moveSelectedRows(int increment) {
        int modelRow;
        if (increment == 0) {
            return;
        }
        if (this.myEntryTable.isEditing()) {
            this.myEntryTable.getCellEditor().stopCellEditing();
        }
        ListSelectionModel selectionModel = this.myEntryTable.getSelectionModel();
        int n = modelRow = increment < 0 ? 0 : this.myModel.getRowCount() - 1;
        while (increment < 0 ? modelRow < this.myModel.getRowCount() : modelRow >= 0) {
            int visibleRow = this.myEntryTable.convertRowIndexToView(modelRow);
            if (selectionModel.isSelectedIndex(visibleRow)) {
                int newVisibleRow = this.myEntryTable.convertRowIndexToView(this.moveRow(modelRow, increment));
                selectionModel.removeSelectionInterval(visibleRow, visibleRow);
                this.myModel.fireTableDataChanged();
                selectionModel.addSelectionInterval(newVisibleRow, newVisibleRow);
            }
            modelRow += increment < 0 ? 1 : -1;
        }
        Rectangle cellRect = this.myEntryTable.getCellRect(selectionModel.getMinSelectionIndex(), 0, true);
        this.myEntryTable.scrollRectToVisible(cellRect);
        this.myEntryTable.repaint();
    }

    private int moveRow(int row, int increment) {
        int newIndex = Math.abs(row + increment) % this.myModel.getRowCount();
        ModuleDependenciesTableItem item = this.myModel.removeDataRow(row);
        this.myModel.addItemAt(item, newIndex);
        return newIndex;
    }

    @NotNull
    private static CellAppearanceEx getCellAppearance(@NotNull ModuleDependenciesTableItem item) {
        BuildFileStatement entry = item.getEntry();
        String data = "";
        Icon icon2 = null;
        if (entry instanceof Dependency) {
            Dependency dependency = (Dependency)entry;
            data = dependency.getValueAsString();
            switch (dependency.type) {
                case EXTERNAL: {
                    icon2 = StudioIcons.Shell.Filetree.MAVEN;
                    break;
                }
                case FILES: {
                    icon2 = StudioIcons.Shell.Filetree.LIBRARY_MODULE;
                    break;
                }
                case MODULE: {
                    icon2 = StudioIcons.Shell.Filetree.ANDROID_MODULE;
                }
            }
        } else if (entry != null) {
            data = entry.toString();
        }
        return SimpleTextCellAppearance.regular((String)data, icon2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() {
        List<ModuleDependenciesTableItem> items2 = this.myModel.getItems();
        ArrayList dependencies = Lists.newArrayListWithExpectedSize((int)items2.size());
        for (ModuleDependenciesTableItem item : items2) {
            dependencies.add(item.getEntry());
        }
        DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(true);
        try {
            WriteAction.run(() -> this.myGradleBuildFile.setValue(BuildFileKey.DEPENDENCIES, dependencies));
        }
        catch (Exception e) {
            LOG.error("Unable to commit dependency changes", (Throwable)e);
        }
        finally {
            DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(false);
        }
        this.myModel.resetModified();
    }

    @Override
    public boolean isModified() {
        return this.myModel.isModified();
    }

    public void select(@NotNull GradleCoordinate dependency) {
        int row = this.myModel.getRow(dependency);
        if (row >= 0) {
            this.myEntryTable.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    private static abstract class PopupAction
    implements Runnable {
        private final Icon myIcon;
        private final int myIndex;
        private final String myTitle;

        protected PopupAction(Icon icon2, int index, String title) {
            this.myIcon = icon2;
            this.myIndex = index;
            this.myTitle = title;
        }

        public String toString() {
            return this.myTitle;
        }
    }

    private static class TableItemRenderer
    extends ColoredTableCellRenderer {
        private final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        private TableItemRenderer() {
        }

        protected void customizeCellRenderer(JTable table2, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column) {
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(this.NO_FOCUS_BORDER);
            if (value2 != null && value2 instanceof ModuleDependenciesTableItem) {
                ModuleDependenciesTableItem tableItem = (ModuleDependenciesTableItem)value2;
                ModuleDependenciesPanel.getCellAppearance(tableItem).customize((SimpleColoredComponent)this);
                this.setToolTipText(tableItem.getTooltipText());
            }
        }
    }
}

