/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.structure.editors.BuildFilePanel;
import com.android.tools.idea.gradle.structure.editors.KeyValuePane;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class SingleObjectPanel
extends BuildFilePanel
implements KeyValuePane.ModificationListener {
    protected final GrClosableBlock myRoot;
    protected final Map<BuildFileKey, Object> myValues = Maps.newHashMap();
    protected final List<BuildFileKey> myProperties;
    protected final KeyValuePane myDetailPane;
    private Set<BuildFileKey> myModifiedKeys = Sets.newHashSet();

    public SingleObjectPanel(@NotNull Project project, @NotNull String moduleName, @Nullable GrClosableBlock root, @NotNull List<BuildFileKey> properties) {
        super(project, moduleName);
        this.myRoot = root;
        this.myProperties = properties;
        this.myDetailPane = new KeyValuePane(project, this);
        if (this.myGradleBuildFile != null) {
            for (BuildFileKey key : properties) {
                Object value2 = this.myGradleBuildFile.getValue((GrStatementOwner)this.myRoot, key);
                if (value2 == null) continue;
                this.myValues.put(key, value2);
            }
        }
    }

    @Override
    protected void addItems(@NotNull JPanel parent) {
        if (this.myGradleBuildFile == null) {
            return;
        }
        this.myDetailPane.init(this.myGradleBuildFile, this.myProperties);
        this.myDetailPane.setCurrentBuildFileObject(this.myValues);
        this.myDetailPane.updateUiFromCurrentObject();
        this.myDetailPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.myDetailPane, "North");
    }

    @Override
    public void apply() {
        if (this.myGradleBuildFile == null) {
            return;
        }
        for (BuildFileKey key : this.myProperties) {
            if (!this.myModifiedKeys.contains((Object)key)) continue;
            Object value2 = this.myValues.get((Object)key);
            if (value2 != null) {
                this.myGradleBuildFile.setValue((GrStatementOwner)this.myRoot, key, value2);
                continue;
            }
            this.myGradleBuildFile.removeValue((GrStatementOwner)this.myRoot, key);
        }
        this.myModifiedKeys.clear();
    }

    @Override
    public boolean isModified() {
        return !this.myModifiedKeys.isEmpty();
    }

    @Override
    public void modified(@NotNull BuildFileKey key) {
        this.myModifiedKeys.add(key);
    }
}

