/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android.dependency;

import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class PsNewDependencyScopes {
    @NotNull
    private final List<PsBuildType> myBuildTypes;
    @NotNull
    private final List<PsProductFlavor> myProductFlavors;
    @NotNull
    private final List<String> myArtifactNames;

    public PsNewDependencyScopes(@NotNull List<PsBuildType> buildTypes, @NotNull List<PsProductFlavor> productFlavors, @NotNull List<String> artifactNames) {
        this.myBuildTypes = buildTypes;
        this.myProductFlavors = productFlavors;
        this.myArtifactNames = artifactNames;
    }

    public boolean contains(@NotNull PsAndroidArtifact artifact) {
        PsVariant variant = artifact.getParent();
        if (this.myBuildTypes.contains(variant.getBuildType())) {
            String resolvedName;
            ArrayList productFlavors = Lists.newArrayList();
            variant.forEachProductFlavor((Function1<? super PsProductFlavor, Unit>)((Function1)e -> {
                productFlavors.add(e);
                return Unit.INSTANCE;
            }));
            if (this.myProductFlavors.containsAll(productFlavors) && this.myArtifactNames.contains(resolvedName = artifact.getResolvedName())) {
                return true;
            }
        }
        return false;
    }
}

