/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.run.AndroidAppRunConfigurationBase;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicAppUtils {
    private static final int UPDATE_BUTTON_INDEX = 1;

    @NotNull
    public static List<Module> getDependentFeatureModules(@NotNull Module module) {
        AndroidModuleModel androidModule = AndroidModuleModel.get(module);
        if (androidModule == null) {
            return ImmutableList.of();
        }
        return DynamicAppUtils.getDependentFeatureModules(module.getProject(), (AndroidProject)androidModule.getAndroidProject());
    }

    @Nullable
    public static Module getBaseFeature(@NotNull Module module) {
        String gradlePath = DynamicAppUtils.getGradlePath(module);
        if (gradlePath == null) {
            return null;
        }
        return Arrays.stream(ModuleManager.getInstance((Project)module.getProject()).getModules()).filter(baseModule -> {
            AndroidModuleModel baseModel = AndroidModuleModel.get(baseModule);
            return baseModel != null && baseModel.getAndroidProject().getDynamicFeatures().contains(gradlePath);
        }).findFirst().orElse(null);
    }

    @NotNull
    public static List<Module> getDependentFeatureModules(@NotNull Project project, @NotNull AndroidProject androidProject) {
        Map<String, Module> featureMap = DynamicAppUtils.getDynamicFeaturesMap(project);
        return androidProject.getDynamicFeatures().stream().map(featurePath -> (Module)featureMap.get(featurePath)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public static List<Module> getModulesToBuild(@NotNull Module module) {
        return Stream.concat(Stream.of(module), DynamicAppUtils.getDependentFeatureModules(module).stream()).collect(Collectors.toList());
    }

    @NotNull
    public static boolean baseIsInstantEnabled(@NotNull Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel model2 = AndroidModuleModel.get(module);
            if (model2 == null || !model2.getAndroidProject().isBaseSplit() || !model2.getSelectedVariant().isInstantAppCompatible()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Module> getModulesSupportingBundleTask(@NotNull Project project) {
        return ProjectStructure.getInstance(project).getAppModules().stream().filter(module -> DynamicAppUtils.supportsBundleTask(module)).collect(Collectors.toList());
    }

    public static boolean supportsBundleTask(@NotNull Module module) {
        AndroidModuleModel androidModule = AndroidModuleModel.get(module);
        if (androidModule == null) {
            return false;
        }
        return !StringUtil.isEmpty((String)androidModule.getSelectedVariant().getMainArtifact().getBundleTaskName());
    }

    public static boolean promptUserForGradleUpdate(@NotNull Project project) {
        HtmlBuilder builder = new HtmlBuilder();
        builder.openHtmlBody();
        builder.add("Building Android App Bundles requires you to update to the latest version of the Android Gradle Plugin.");
        builder.newline();
        builder.addLink("Learn More", "https://d.android.com/r/studio-ui/dynamic-delivery/overview.html");
        builder.newline();
        builder.newline();
        builder.add("App bundles allow you to support multiple device configurations from a single build artifact.");
        builder.newline();
        builder.add("App stores that support the bundle format use it to build and sign your APKs for you, and");
        builder.newline();
        builder.add("serve those APKs to users as needed.");
        builder.newline();
        builder.newline();
        builder.closeHtmlBody();
        int result2 = Messages.showDialog((Project)project, (String)builder.getHtml(), (String)"Update the Android Gradle Plugin", (String[])new String[]{Messages.CANCEL_BUTTON, "Update"}, (int)1, (Icon)AllIcons.General.WarningDialog);
        if (result2 == 1) {
            ApplicationManager.getApplication().invokeLater(() -> {
                GradleVersion gradleVersion2 = GradleVersion.parse((String)"5.4.1");
                GradleVersion pluginVersion = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
                AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(project);
                updater.updatePluginVersion(pluginVersion, gradleVersion2);
            });
        }
        return result2 == 1;
    }

    @NotNull
    public static String getFeatureNameFromPathHack(@NotNull Path path) {
        String fileName = path.getFileName().toString();
        int separatorIndex = fileName.lastIndexOf(45);
        if (separatorIndex < 0) {
            return "";
        }
        return fileName.substring(0, separatorIndex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ApkInfo collectAppBundleOutput(@NotNull Module module, @NotNull PostBuildModelProvider outputModelProvider, @NotNull String pkgName) {
        AppBundleVariantBuildOutput variantBuildOutput;
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel == null) {
            DynamicAppUtils.getLogger().warn("Android model is null. Sync might have failed");
            return null;
        }
        PostBuildModel model2 = outputModelProvider.getPostBuildModel();
        if (model2 == null) {
            DynamicAppUtils.getLogger().warn("Post build model is null. Build might have failed.");
            return null;
        }
        AppBundleProjectBuildOutput output = model2.findAppBundleProjectBuildOutput(module);
        if (output == null) {
            DynamicAppUtils.getLogger().warn("Project output is null. Build may have failed.");
            return null;
        }
        Iterator iterator = output.getAppBundleVariantsBuildOutput().iterator();
        do {
            if (iterator.hasNext()) continue;
            DynamicAppUtils.getLogger().warn("Bundle variant build output model has no entries. Build may have failed.");
            return null;
        } while (!(variantBuildOutput = (AppBundleVariantBuildOutput)iterator.next()).getName().equals(androidModel.getSelectedVariant().getName()));
        File apkFolder = variantBuildOutput.getApkFolder();
        try (Stream<Path> stream = Files.list(apkFolder.toPath());){
            List<ApkFileUnit> apks = stream.map(path -> new ApkFileUnit(DynamicAppUtils.getFeatureNameFromPathHack(path), path.toFile())).collect(Collectors.toList());
            ApkInfo apkInfo = new ApkInfo(apks, pkgName);
            return apkInfo;
        }
        catch (IOException e) {
            DynamicAppUtils.getLogger().warn(String.format("Error reading list of APK files from bundle build output directory \"%s\".", apkFolder), (Throwable)e);
            return null;
        }
    }

    public static boolean useSelectApksFromBundleBuilder(@NotNull Module module, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (configuration instanceof AndroidAppRunConfigurationBase) {
            AndroidAppRunConfigurationBase androidConfiguration = (AndroidAppRunConfigurationBase)configuration;
            if (androidConfiguration.DEPLOY_APK_FROM_BUNDLE) {
                Preconditions.checkArgument((boolean)androidConfiguration.DEPLOY);
                return true;
            }
        }
        return targetDevices.stream().anyMatch(device -> device.getVersion().getFeatureLevel() < 21) && !DynamicAppUtils.getDependentFeatureModules(module).isEmpty();
    }

    public static boolean shouldCollectListOfLanguages(@NotNull Module module, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (!DynamicAppUtils.useSelectApksFromBundleBuilder(module, configuration, targetDevices)) {
            return false;
        }
        return targetDevices.stream().allMatch(device -> device.getVersion().getFeatureLevel() >= 21);
    }

    @NotNull
    public static List<Module> getDependentInstantFeatureModules(@NotNull Module module) {
        AndroidModuleModel androidModule = AndroidModuleModel.get(module);
        if (androidModule == null) {
            return ImmutableList.of();
        }
        return DynamicAppUtils.getDependentInstantFeatureModules(module.getProject(), (AndroidProject)androidModule.getAndroidProject());
    }

    @NotNull
    public static List<Module> getDependentInstantFeatureModules(@NotNull Project project, @NotNull AndroidProject androidProject) {
        Map<String, Module> featureMap = DynamicAppUtils.getDynamicFeaturesMap(project);
        return androidProject.getDynamicFeatures().stream().map(featurePath -> (Module)featureMap.get(featurePath)).filter(Objects::nonNull).filter(f -> AndroidModuleModel.get(f).getSelectedVariant().isInstantAppCompatible()).collect(Collectors.toList());
    }

    public static boolean isFeatureEnabled(@NotNull List<String> myDisabledFeatures, @NotNull ApkFileUnit apkFileUnit) {
        return myDisabledFeatures.stream().noneMatch(m -> DynamicAppUtils.featureNameEquals(apkFileUnit, m));
    }

    public static boolean featureNameEquals(@NotNull ApkFileUnit apkFileUnit, @NotNull String featureName) {
        return StringUtil.equals((CharSequence)featureName.replace('-', '_'), (CharSequence)apkFileUnit.getModuleName());
    }

    @NotNull
    private static Map<String, Module> getDynamicFeaturesMap(@NotNull Project project) {
        return Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).map(module -> {
            AndroidModuleModel model2 = AndroidModuleModel.get(module);
            if (model2 == null) {
                return null;
            }
            if (model2.getAndroidProject().getProjectType() != 6) {
                return null;
            }
            String gradlePath = DynamicAppUtils.getGradlePath(module);
            if (gradlePath == null) {
                return null;
            }
            return Pair.create((Object)gradlePath, (Object)module);
        }).filter(Objects::nonNull).collect(Collectors.toMap(p -> (String)p.first, p -> (Module)p.second, DynamicAppUtils::handleModuleAmbiguity));
    }

    @Nullable
    private static String getGradlePath(@NotNull Module module) {
        GradleFacet facet = GradleFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        GradleModuleModel gradleModel = facet.getGradleModuleModel();
        if (gradleModel == null) {
            return null;
        }
        return gradleModel.getGradlePath();
    }

    @NotNull
    private static Module handleModuleAmbiguity(@NotNull Module m1, @NotNull Module m2) {
        DynamicAppUtils.getLogger().warn(String.format("Unexpected ambiguity processing modules: %s - %s", m1.getName(), m2.getName()));
        return m1;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(DynamicAppUtils.class);
    }
}

