/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedDistributionPaths {
    @NotNull
    public static EmbeddedDistributionPaths getInstance() {
        return (EmbeddedDistributionPaths)ServiceManager.getService(EmbeddedDistributionPaths.class);
    }

    @NotNull
    public List<File> findAndroidStudioLocalMavenRepoPaths() {
        File npwRepoPath;
        if (!((Boolean)StudioFlags.USE_DEVELOPMENT_OFFLINE_REPOS.get()).booleanValue() && !CommandLineArgs.isInTestingMode()) {
            return ImmutableList.of();
        }
        ArrayList<File> repoPaths = new ArrayList<File>();
        String studioCustomRepo = System.getenv("STUDIO_CUSTOM_REPO");
        if (studioCustomRepo != null) {
            File customRepoPath = new File(FileUtil.toCanonicalPath((String)FileUtil.toSystemDependentName((String)studioCustomRepo)));
            if (!customRepoPath.isDirectory()) {
                throw new IllegalArgumentException("Invalid path in STUDIO_CUSTOM_REPO environment variable");
            }
            repoPaths.add(customRepoPath);
        } else {
            File localGMaven = new File(PathManager.getHomePath() + FileUtil.toSystemDependentName((String)"/../../out/repo"));
            if (localGMaven.isDirectory()) {
                repoPaths.add(localGMaven);
            }
            File prebuiltOfflineM2 = new File(FileUtil.toCanonicalPath((String)(EmbeddedDistributionPaths.getIdeHomePath() + FileUtil.toSystemDependentName((String)"/../../prebuilts/tools/common/offline-m2"))));
            EmbeddedDistributionPaths.getLog().info("Looking for embedded Maven repo at '" + prebuiltOfflineM2.getPath() + "'");
            if (prebuiltOfflineM2.isDirectory()) {
                repoPaths.add(prebuiltOfflineM2);
            }
        }
        File localOfflineRepoPath = new File(PathManager.getHomePath() + FileUtil.toSystemDependentName((String)"/../../out/studio/repo"));
        if (localOfflineRepoPath.isDirectory()) {
            repoPaths.add(localOfflineRepoPath);
        }
        if (((Boolean)StudioFlags.SHIPPED_SYNC_ENABLED.get()).booleanValue() && (npwRepoPath = new File(PathManager.getHomePath() + FileUtil.toSystemDependentName((String)"/../adt/idea/android/testData/nosyncbuilder/offline_repo"))).isDirectory()) {
            repoPaths.add(npwRepoPath);
        }
        return ImmutableList.copyOf(repoPaths);
    }

    @NotNull
    public File findEmbeddedProfilerTransform(@NotNull AndroidVersion version2) {
        File file = new File(PathManager.getHomePath(), "plugins/android/resources/profilers-transform.jar");
        if (file.exists()) {
            return file;
        }
        String relativePath = FileUtil.toSystemDependentName((String)"/../../bazel-genfiles/tools/base/profiler/transform/profilers-transform.jar");
        return new File(PathManager.getHomePath() + relativePath);
    }

    @Nullable
    public File findEmbeddedGradleDistributionPath() {
        File distributionPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (distributionPath != null) {
            Logger log = EmbeddedDistributionPaths.getLog();
            File embeddedPath = new File(distributionPath, "gradle-5.4.1");
            log.info("Looking for embedded Gradle distribution at '" + embeddedPath.getPath() + "'");
            if (embeddedPath.isDirectory()) {
                log.info("Found embedded Gradle 5.4.1");
                return embeddedPath;
            }
            log.info("Unable to find embedded Gradle 5.4.1");
            return null;
        }
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        String relativePath = FileUtil.toSystemDependentName((String)"/../../tools/external/gradle");
        distributionPath = new File(FileUtil.toCanonicalPath((String)(ideHomePath + relativePath)));
        if (distributionPath.isDirectory()) {
            return distributionPath;
        }
        String localDistributionPath = System.getProperty("local.gradle.distribution.path");
        if (localDistributionPath != null && (distributionPath = new File(FileUtil.toCanonicalPath((String)localDistributionPath))).isDirectory()) {
            return distributionPath;
        }
        return null;
    }

    @Nullable
    public File findEmbeddedGradleDistributionFile(@NotNull String gradleVersion2) {
        File distributionPath = this.findEmbeddedGradleDistributionPath();
        if (distributionPath != null) {
            File allDistributionFile = new File(distributionPath, "gradle-" + gradleVersion2 + "-all.zip");
            if (allDistributionFile.isFile() && allDistributionFile.exists()) {
                return allDistributionFile;
            }
            File binDistributionFile = new File(distributionPath, "gradle-" + gradleVersion2 + "-bin.zip");
            if (binDistributionFile.isFile() && binDistributionFile.exists()) {
                return binDistributionFile;
            }
        }
        return null;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(EmbeddedDistributionPaths.class);
    }

    @Nullable
    private static File getDefaultRootDirPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File rootDirPath = new File(ideHomePath, "gradle");
        return rootDirPath.isDirectory() ? rootDirPath : null;
    }

    @Nullable
    public File tryToGetEmbeddedJdkPath() {
        try {
            return this.getEmbeddedJdkPath();
        }
        catch (Throwable t) {
            Logger.getInstance(EmbeddedDistributionPaths.class).warn("Failed to find a valid embedded JDK", t);
            return null;
        }
    }

    @NotNull
    public File getEmbeddedJdkPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File jdkRootPath = new File(ideHomePath, SystemInfo.isMac ? FileUtil.join((String[])new String[]{"jre", "jdk"}) : "jre");
        if (jdkRootPath.isDirectory()) {
            return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
        }
        if (System.getProperty("android.test.embedded.jdk") != null) {
            File jdkDir = new File(System.getProperty("android.test.embedded.jdk"));
            assert (jdkDir.exists());
            return jdkDir;
        }
        String jdkDevPath = System.getProperty("studio.dev.jdk", ideHomePath + "/../../prebuilts/studio/jdk");
        String relativePath = FileUtil.toSystemDependentName((String)jdkDevPath);
        jdkRootPath = new File(FileUtil.toCanonicalPath((String)relativePath));
        if (SystemInfo.isWindows) {
            jdkRootPath = new File(jdkRootPath, "win64");
        } else if (SystemInfo.isLinux) {
            jdkRootPath = new File(jdkRootPath, "linux");
        } else if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "mac");
        }
        return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
    }

    @NotNull
    private static File getSystemSpecificJdkPath(File jdkRootPath) {
        if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "/Contents/Home");
        }
        if (!jdkRootPath.isDirectory()) {
            throw new Error(String.format("Incomplete or corrupted installation - \"%s\" directory does not exist", jdkRootPath.toString()));
        }
        return jdkRootPath;
    }

    @NotNull
    private static String getIdeHomePath() {
        return FileUtil.toSystemDependentName((String)PathManager.getHomePath());
    }
}

