/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.gradle.initialization.BuildLayoutParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleLocalCache {
    @NotNull
    public static GradleLocalCache getInstance() {
        return (GradleLocalCache)ServiceManager.getService(GradleLocalCache.class);
    }

    @Nullable
    public GradleVersion findLatestArtifactVersion(@NotNull GradleCoordinate artifactCoordinate, @Nullable Project project, @Nullable String versionPrefix) {
        String groupId = artifactCoordinate.getGroupId();
        String artifactId = artifactCoordinate.getArtifactId();
        if (StringUtil.isNotEmpty((String)groupId) && StringUtil.isNotEmpty((String)artifactId)) {
            return this.findLatestArtifactVersion(groupId, artifactId, project, versionPrefix);
        }
        return null;
    }

    @Nullable
    public GradleVersion findLatestArtifactVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Project project, @Nullable String versionPrefix) {
        for (File gradleServicePath : GradleLocalCache.getGradleServicePaths(project)) {
            GradleVersion version2 = GradleLocalCache.findLatestVersionInGradleCache(gradleServicePath, groupId, artifactId, versionPrefix);
            if (version2 == null) continue;
            return version2;
        }
        return null;
    }

    @Nullable
    private static GradleVersion findLatestVersionInGradleCache(@NotNull File gradleServicePath, @NotNull String groupId, @NotNull String artifactId, @Nullable String versionPrefix) {
        File gradleCacheFolder = new File(gradleServicePath, "caches");
        if (!gradleCacheFolder.isDirectory()) {
            return null;
        }
        ArrayList versions = Lists.newArrayList();
        for (File moduleFolder : FileUtil.notNullize((File[])gradleCacheFolder.listFiles())) {
            if (!GradleLocalCache.isDirectoryWithNamePrefix(moduleFolder, "modules-")) continue;
            for (File metadataFolder : FileUtil.notNullize((File[])moduleFolder.listFiles())) {
                File versionFolder;
                if (!GradleLocalCache.isDirectoryWithNamePrefix(metadataFolder, "metadata-") || !(versionFolder = new File(metadataFolder, FileUtil.join((String[])new String[]{"descriptors", groupId, artifactId}))).isDirectory()) continue;
                for (File versionFile : FileUtil.notNullize((File[])versionFolder.listFiles())) {
                    GradleVersion parsedVersion;
                    String version2 = versionFile.getName();
                    if (versionPrefix != null && !version2.startsWith(versionPrefix) || version2.isEmpty() || !Character.isDigit(version2.charAt(0)) || (parsedVersion = GradleVersion.tryParse((String)version2)) == null) continue;
                    versions.add(parsedVersion);
                }
            }
        }
        int versionCount = versions.size();
        if (versionCount == 1) {
            return (GradleVersion)versions.get(0);
        }
        if (versionCount > 1) {
            Collections.sort(versions);
            return (GradleVersion)versions.get(versionCount - 1);
        }
        return null;
    }

    private static boolean isDirectoryWithNamePrefix(@NotNull File file, @NotNull String prefix) {
        return file.getName().startsWith(prefix) && file.isDirectory();
    }

    public boolean containsGradleWrapperVersion(@NotNull String gradleVersion2, @NotNull Project project) {
        String distFolderName = "gradle-" + gradleVersion2;
        String wrapperDirNamePrefix = distFolderName + "-";
        String[] wrapperFolderNames = new String[]{wrapperDirNamePrefix + "all", wrapperDirNamePrefix + "bin"};
        for (File gradleServicePath : GradleLocalCache.getGradleServicePaths(project)) {
            for (String wrapperFolderName : wrapperFolderNames) {
                File wrapperFolderPath = new File(gradleServicePath, FileUtil.join((String[])new String[]{"wrapper", "dists", wrapperFolderName}));
                if (!wrapperFolderPath.isDirectory()) continue;
                for (File mayBeDistParent : FileUtil.notNullize((File[])wrapperFolderPath.listFiles())) {
                    if (!mayBeDistParent.isDirectory()) continue;
                    for (File mayBeDistFolder : FileUtil.notNullize((File[])mayBeDistParent.listFiles())) {
                        if (!mayBeDistFolder.isDirectory() || !distFolderName.equals(mayBeDistFolder.getName())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @NotNull
    private static Collection<File> getGradleServicePaths(@Nullable Project project) {
        File path;
        File file;
        GradleSettings settings;
        String path2;
        LinkedHashSet<File> paths2 = new LinkedHashSet<File>();
        if (project != null && StringUtil.isNotEmpty((String)(path2 = (settings = GradleSettings.getInstance((Project)project)).getServiceDirectoryPath())) && (file = new File(path2)).isDirectory()) {
            paths2.add(file);
        }
        if ((path = new BuildLayoutParameters().getGradleUserHomeDir()).isDirectory()) {
            paths2.add(path);
        }
        return paths2;
    }
}

