/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleProjects {
    private static final Key<Boolean> SYNC_REQUESTED_DURING_BUILD = Key.create((String)"project.sync.requested.during.build");

    private GradleProjects() {
    }

    public static void executeProjectChanges(@NotNull Project project, @NotNull Runnable changes) {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            if (!project.isDisposed()) {
                changes.run();
            }
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (!project.isDisposed()) {
                ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
            }
        }));
    }

    public static void open(@NotNull Project project) {
        boolean fullScreen;
        IdeFocusManager instance;
        IdeFrame lastFocusedFrame;
        ProjectUtil.updateLastProjectLocation((String)project.getBasePath());
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
            project.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
        }
        ProjectManagerEx.getInstanceEx().openProject(project);
    }

    public static boolean isOfflineBuildModeEnabled(@NotNull Project project) {
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    @Nullable
    public static AndroidModel getAndroidModel(@NotNull Module module) {
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        return androidFacet != null ? ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel() : null;
    }

    @Deprecated
    @NotNull
    public static Module[] getModulesToBuildFromSelection(@NotNull Project project, @Nullable DataContext dataContext) {
        return GradleProjectInfo.getInstance(project).getModulesToBuildFromSelection(dataContext);
    }

    @Nullable
    public static File findModuleRootFolderPath(@NotNull Module module) {
        File moduleFilePath = FilePaths.toSystemDependentPath((String)module.getModuleFilePath());
        return moduleFilePath.getParentFile();
    }

    @Deprecated
    public static boolean isBuildWithGradle(@NotNull Project project) {
        return GradleProjectInfo.getInstance(project).isBuildWithGradle();
    }

    public static boolean isGradleProjectModule(@NotNull Module module) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.requiresAndroidModel() && GradleFacet.isAppliedTo(module)) {
            File moduleFilePath = FilePaths.toSystemDependentPath((String)module.getModuleFilePath());
            File moduleRootDirPath = moduleFilePath.getParentFile();
            return FileUtil.pathsEqual((String)moduleRootDirPath.getPath(), (String)module.getProject().getBasePath());
        }
        return !GradleFacet.isAppliedTo(module);
    }

    public static boolean canImportAsGradleProject(@NotNull VirtualFile importSource) {
        VirtualFile target = ProjectImportUtil.findImportTarget(importSource);
        return "gradle".equals(target.getExtension()) || target.getName().endsWith("gradle.kts");
    }

    public static void setSyncRequestedDuringBuild(@NotNull Project project, @Nullable Boolean value2) {
        project.putUserData(SYNC_REQUESTED_DURING_BUILD, (Object)value2);
    }

    public static boolean isSyncRequestedDuringBuild(@NotNull Project project) {
        return (Boolean)SYNC_REQUESTED_DURING_BUILD.get((UserDataHolder)project, (Object)false);
    }

    public static boolean isIdeaAndroidModule(@NotNull Module module) {
        if (GradleFacet.getInstance(module) != null || JavaFacet.getInstance(module) != null) {
            return true;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        return androidFacet != null && androidFacet.requiresAndroidModel();
    }

    public static boolean containsExternalCppProjects(@NotNull Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
            if (ndkModuleModel == null) continue;
            return true;
        }
        return false;
    }
}

