/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.util.ProxySettings;
import com.android.tools.idea.util.PropertiesFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProperties {
    @NonNls
    private static final String JVM_ARGS_PROPERTY_NAME = "org.gradle.jvmargs";
    @NotNull
    private final File myPath;
    private final Properties myProperties;

    public GradleProperties(@NotNull Project project) throws IOException {
        this(new File(Projects.getBaseDirPath((Project)project), "gradle.properties"));
    }

    public GradleProperties(@NotNull File path) throws IOException {
        this.myPath = path;
        this.myProperties = PropertiesFiles.getProperties(this.myPath);
    }

    @VisibleForTesting
    String getProperty(@NotNull String name) {
        return this.myProperties.getProperty(name);
    }

    @NotNull
    public ProxySettings getHttpProxySettings() {
        return new ProxySettings(this.myProperties, "http");
    }

    @NotNull
    public ProxySettings getHttpsProxySettings() {
        return new ProxySettings(this.myProperties, "https");
    }

    public void save() throws IOException {
        PropertiesFiles.savePropertiesToFile(this.myProperties, this.myPath, GradleProperties.getHeaderComment());
    }

    @NotNull
    private static String getHeaderComment() {
        Object[] lines = new String[]{"# For more details on how to configure your build environment visit", "# http://www.gradle.org/docs/current/userguide/build_environment.html", "", "# Specifies the JVM arguments used for the daemon process.", "# The setting is particularly useful for tweaking memory settings.", "# Default value: -Xmx1024m -XX:MaxPermSize=256m", "# org.gradle.jvmargs=-Xmx2048m -XX:MaxPermSize=512m -XX:+HeapDumpOnOutOfMemoryError -Dfile.encoding=UTF-8", "", "# When configured, Gradle will run in incubating parallel mode.", "# This option should only be used with decoupled projects. More details, visit", "# http://www.gradle.org/docs/current/userguide/multi_project_builds.html#sec:decoupled_projects", "# org.gradle.parallel=true"};
        return Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
    }

    public void setJvmArgs(@NotNull String jvmArgs) {
        this.myProperties.setProperty(JVM_ARGS_PROPERTY_NAME, jvmArgs);
    }

    public void clear() {
        this.myProperties.clear();
    }

    @Nullable
    public String getJvmArgs() {
        return this.myProperties.getProperty(JVM_ARGS_PROPERTY_NAME);
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    @NotNull
    public File getPath() {
        return this.myPath;
    }

    @NotNull
    public static File getUserGradlePropertiesFile() {
        String home = System.getProperty("user.home");
        return new File(new File(home), FileUtil.toSystemDependentName((String)".gradle/gradle.properties"));
    }
}

