/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.utils.FileUtils;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleUtil {
    public static final ProjectSystemId GRADLE_SYSTEM_ID = GradleConstants.SYSTEM_ID;
    @NonNls
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Logger LOG = Logger.getInstance(GradleUtil.class);
    private static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");
    private static final Pattern PLUGIN_VERSION_PATTERN = Pattern.compile("[012]\\..*");

    private GradleUtil() {
    }

    @NotNull
    public static File getCacheFolderRootPath(@NotNull Project project) {
        return new File(project.getBasePath(), FileUtil.join((String[])new String[]{".idea", "caches"}));
    }

    public static void clearStoredGradleJvmArgs(@NotNull Project project) {
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        String existingJvmArgs = settings.getGradleVmOptions();
        settings.setGradleVmOptions(null);
        if (!StringUtil.isEmptyOrSpaces((String)existingJvmArgs)) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                String jvmArgs = existingJvmArgs.trim();
                String msg = String.format("Starting with version 1.3, Android Studio no longer supports IDE-specific Gradle JVM arguments.\n\nAndroid Studio will now remove any stored Gradle JVM arguments.\n\nWould you like to copy these JVM arguments:\n%1$s\nto the project's gradle.properties file?\n\n(Any existing JVM arguments in the gradle.properties file will be overwritten.)", jvmArgs);
                int result2 = Messages.showYesNoDialog((Project)project, (String)msg, (String)"Gradle Settings", (Icon)Messages.getQuestionIcon());
                if (result2 == 0) {
                    try {
                        GradleProperties gradleProperties = new GradleProperties(project);
                        gradleProperties.setJvmArgs(jvmArgs);
                        gradleProperties.save();
                    }
                    catch (IOException e) {
                        String err = String.format("Failed to copy JVM arguments '%1$s' to the project's gradle.properties file.", existingJvmArgs);
                        LOG.info(err, (Throwable)e);
                        String cause = e.getMessage();
                        if (StringUtil.isNotEmpty((String)cause)) {
                            err = err + String.format("<br>\nCause: %1$s", cause);
                        }
                        AndroidNotification.getInstance(project).showBalloon("Gradle Settings", err, NotificationType.ERROR);
                    }
                } else {
                    String text = String.format("JVM arguments<br>\n'%1$s'<br>\nwere not copied to the project's gradle.properties file.", existingJvmArgs);
                    AndroidNotification.getInstance(project).showBalloon("Gradle Settings", text, NotificationType.WARNING);
                }
            });
        }
    }

    public static boolean isSupportedGradleVersion(@NotNull GradleVersion gradleVersion2) {
        GradleVersion supported = GradleVersion.parse((String)"5.4.1");
        return supported.compareTo(gradleVersion2) <= 0;
    }

    @Deprecated
    @NotNull
    public static AndroidArtifactOutput getOutput(@NotNull AndroidArtifact artifact) {
        Collection outputs = artifact.getOutputs();
        assert (!outputs.isEmpty());
        AndroidArtifactOutput output = (AndroidArtifactOutput)ContainerUtil.getFirstItem((Collection)outputs);
        assert (output != null);
        return output;
    }

    @NotNull
    public static Icon getModuleIcon(@NotNull Module module) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel != null) {
            return GradleUtil.getAndroidModuleIcon(androidModel);
        }
        return AndroidProjectInfo.getInstance(module.getProject()).requiresAndroidModel() ? AllIcons.Nodes.PpJdk : StudioIcons.Shell.Filetree.ANDROID_MODULE;
    }

    @NotNull
    public static Icon getAndroidModuleIcon(@NotNull AndroidModuleModel androidModuleModel) {
        return GradleUtil.getAndroidModuleIcon(androidModuleModel.getAndroidProject().getProjectType());
    }

    @NotNull
    public static Icon getAndroidModuleIcon(int androidProjectType) {
        switch (androidProjectType) {
            case 0: {
                return StudioIcons.Shell.Filetree.ANDROID_MODULE;
            }
            case 5: {
                return StudioIcons.Shell.Filetree.FEATURE_MODULE;
            }
            case 4: {
                return StudioIcons.Shell.Filetree.INSTANT_APPS;
            }
            case 1: {
                return StudioIcons.Shell.Filetree.LIBRARY_MODULE;
            }
            case 2: {
                return StudioIcons.Shell.Filetree.ANDROID_TEST_ROOT;
            }
        }
        return StudioIcons.Shell.Filetree.ANDROID_MODULE;
    }

    @Nullable
    public static IdeAndroidProject getAndroidProject(@NotNull Module module) {
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        return gradleModel != null ? gradleModel.getAndroidProject() : null;
    }

    @Nullable
    public static NativeAndroidProject getNativeAndroidProject(@NotNull Module module) {
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
        return ndkModuleModel != null ? ndkModuleModel.getAndroidProject() : null;
    }

    @Nullable
    public static String getGradlePath(@NotNull Module module) {
        GradleFacet facet = GradleFacet.getInstance(module);
        return facet != null ? ((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    public static boolean isRootModuleWithNoSources(@NotNull Module module) {
        String gradlePath;
        return ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 0 && ((gradlePath = GradleUtil.getGradlePath(module)) == null || gradlePath.equals(":"));
    }

    @NotNull
    public static List<Library> getModuleDependencies(@NotNull IdeVariant variant) {
        ArrayList libraries = Lists.newArrayList();
        IdeAndroidArtifact mainArtifact = variant.getMainArtifact();
        IdeDependencies dependencies = mainArtifact.getLevel2Dependencies();
        libraries.addAll(dependencies.getModuleDependencies());
        for (IdeBaseArtifact testArtifact : variant.getTestArtifacts()) {
            dependencies = testArtifact.getLevel2Dependencies();
            libraries.addAll(dependencies.getModuleDependencies());
        }
        return libraries.stream().distinct().collect(Collectors.toList());
    }

    @Nullable
    public static Module findModuleByGradlePath(@NotNull Project project, @NotNull String gradlePath) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null || !gradlePath.equals(((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH)) continue;
            return module;
        }
        return null;
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        return Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)gradlePath);
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module) {
        VirtualFile buildFile;
        GradleModuleModel moduleModel = GradleUtil.getGradleModuleModel(module);
        if (moduleModel != null) {
            return moduleModel.getBuildFile();
        }
        if (GradleProjects.isGradleProjectModule(module) && (buildFile = GradleUtil.getGradleBuildFileFromProjectModule(module)) != null) {
            return buildFile;
        }
        File moduleFilePath = new File(module.getModuleFilePath());
        File parentFile = moduleFilePath.getParentFile();
        return parentFile != null ? GradleUtil.getGradleBuildFile(parentFile) : null;
    }

    @Nullable
    private static GradleModuleModel getGradleModuleModel(Module module) {
        GradleFacet gradleFacet = GradleFacet.getInstance(module);
        if (gradleFacet == null) {
            return null;
        }
        return gradleFacet.getGradleModuleModel();
    }

    @Nullable
    private static VirtualFile getGradleBuildFileFromProjectModule(@NotNull Module module) {
        String basePath = module.getProject().getBasePath();
        if (StringUtil.isEmptyOrSpaces((String)basePath)) {
            return null;
        }
        return GradleUtil.getGradleBuildFile(new File(basePath));
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        File gradleBuildFilePath = GradleUtil.getGradleBuildFilePath(dirPath);
        VirtualFile result2 = VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)false);
        return result2 != null && result2.isValid() ? result2 : null;
    }

    @NotNull
    public static File getGradleBuildFilePath(@NotNull File dirPath) {
        File ktsBuildFile;
        File defaultBuildFile = new File(dirPath, "build.gradle");
        if (!defaultBuildFile.isFile() && (ktsBuildFile = new File(dirPath, "build.gradle.kts")).isFile()) {
            return ktsBuildFile;
        }
        return defaultBuildFile;
    }

    @Nullable
    public static VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        File gradleSettingsFilePath = GradleUtil.getGradleSettingsFilePath(dirPath);
        VirtualFile result2 = VfsUtil.findFileByIoFile((File)gradleSettingsFilePath, (boolean)false);
        return result2 != null && result2.isValid() ? result2 : null;
    }

    @NotNull
    public static File getGradleSettingsFilePath(@NotNull File dirPath) {
        File ktsSettingsFile;
        File defaultSettingsFile = new File(dirPath, "settings.gradle");
        if (!defaultSettingsFile.isFile() && (ktsSettingsFile = new File(dirPath, "settings.gradle.kts")).isFile()) {
            return ktsSettingsFile;
        }
        return defaultSettingsFile;
    }

    @NotNull
    public static GradleExecutionSettings getOrCreateGradleExecutionSettings(@NotNull Project project) {
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(project);
        if (IdeInfo.getInstance().isAndroidStudio() && executionSettings == null) {
            File gradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath();
            assert (gradlePath != null && gradlePath.isDirectory());
            executionSettings = new GradleExecutionSettings(gradlePath.getPath(), null, DistributionType.LOCAL, null, false);
            File jdkPath = IdeSdks.getInstance().getJdkPath();
            if (jdkPath != null) {
                executionSettings.setJavaHome(jdkPath.getPath());
            }
        }
        if (executionSettings == null) {
            executionSettings = new GradleExecutionSettings(null, null, DistributionType.BUNDLED, null, false);
        }
        return executionSettings;
    }

    @Nullable
    public static GradleExecutionSettings getGradleExecutionSettings(@NotNull Project project) {
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            File baseDirPath = Projects.getBaseDirPath((Project)project);
            String msg = String.format("Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'", project.getName(), baseDirPath.getPath());
            LOG.info(msg);
            return null;
        }
        try {
            return (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)GRADLE_SYSTEM_ID);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static GradleProjectSettings getGradleProjectSettings(@NotNull Project project) {
        return GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
    }

    @VisibleForTesting
    @Nullable
    static String getGradleInvocationJvmArg(@Nullable BuildMode buildMode) {
        if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
            return AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
        }
        return null;
    }

    public static void stopAllGradleDaemonsAndRestart() {
        DefaultGradleConnector.close();
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).restart(true);
        } else {
            application.restart();
        }
    }

    @NotNull
    public static String getDefaultPhysicalPathFromGradlePath(@NotNull String gradlePath) {
        List<String> segments = GradleUtil.getPathSegments(gradlePath);
        return FileUtil.join((String[])ArrayUtil.toStringArray(segments));
    }

    @NotNull
    public static File getModuleDefaultPath(@NotNull VirtualFile parentDir, @NotNull String gradlePath) {
        assert (!gradlePath.isEmpty());
        String relativePath = GradleUtil.getDefaultPhysicalPathFromGradlePath(gradlePath);
        return new File(VfsUtilCore.virtualToIoFile((VirtualFile)parentDir), relativePath);
    }

    public static int isValidGradlePath(@NotNull String gradlePath) {
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    public static boolean hasModule(@Nullable Project project, @NotNull String gradlePath) {
        if (project == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!gradlePath.equals(GradleUtil.getGradlePath(module))) continue;
            return true;
        }
        File location = GradleUtil.getModuleDefaultPath(project.getBaseDir(), gradlePath);
        if (location.isFile()) {
            return true;
        }
        if (location.isDirectory()) {
            File[] children = location.listFiles();
            return children == null || children.length > 0;
        }
        return false;
    }

    @Nullable
    public static GradleVersion getAndroidGradleModelVersionInUse(@NotNull Project project) {
        HashSet foundInLibraries = Sets.newHashSet();
        HashSet foundInApps = Sets.newHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            String modelVersion = androidProject.getModelVersion();
            if (androidModel.getAndroidProject().getProjectType() == 0) {
                foundInApps.add(modelVersion);
                continue;
            }
            foundInLibraries.add(modelVersion);
        }
        String found = null;
        if (foundInApps.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInApps);
        } else if (foundInApps.isEmpty() && foundInLibraries.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInLibraries);
        }
        return found != null ? GradleVersion.tryParse((String)found) : null;
    }

    @Nullable
    public static GradleVersion getAndroidGradleModelVersionInUse(@NotNull Module module) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            return GradleVersion.tryParse((String)androidProject.getModelVersion());
        }
        return null;
    }

    public static void attemptToUseEmbeddedGradle(@NotNull Project project) {
        GradleWrapper gradleWrapper;
        if (IdeInfo.getInstance().isAndroidStudio() && (gradleWrapper = GradleWrapper.find(project)) != null) {
            GradleProjectSettings gradleSettings;
            File embeddedGradlePath;
            String gradleVersion2 = null;
            try {
                Properties properties = gradleWrapper.getProperties();
                String url = properties.getProperty("distributionUrl");
                gradleVersion2 = GradleUtil.getGradleWrapperVersionOnlyIfComingForGradleDotOrg(url);
            }
            catch (IOException e) {
                LOG.warn("Failed to read file " + gradleWrapper.getPropertiesFilePath().getPath());
            }
            if (gradleVersion2 != null && GradleUtil.isCompatibleWithEmbeddedGradleVersion(gradleVersion2) && !GradleLocalCache.getInstance().containsGradleWrapperVersion(gradleVersion2, project) && (embeddedGradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath()) != null && (gradleSettings = GradleUtil.getGradleProjectSettings(project)) != null) {
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                gradleSettings.setGradleHome(embeddedGradlePath.getPath());
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static String getGradleWrapperVersionOnlyIfComingForGradleDotOrg(@Nullable String url) {
        String version2;
        String expectedPrefix;
        String protocol;
        int foundIndex;
        if (url != null && (foundIndex = url.indexOf("://")) != -1 && ((protocol = url.substring(0, foundIndex)).equals("http") || protocol.equals("https")) && url.startsWith(expectedPrefix = protocol + "://services.gradle.org/distributions/gradle-") && (foundIndex = url.indexOf(45, expectedPrefix.length())) != -1 && StringUtil.isNotEmpty((String)(version2 = url.substring(expectedPrefix.length(), foundIndex)))) {
            return version2;
        }
        return null;
    }

    private static boolean isCompatibleWithEmbeddedGradleVersion(@NotNull String gradleVersion2) {
        return gradleVersion2.equals("5.4.1") || gradleVersion2.equals("5.4.1");
    }

    public static boolean dependsOn(AndroidModuleModel androidModel, String artifact) {
        IdeDependencies dependencies = androidModel.getSelectedMainCompileLevel2Dependencies();
        return GradleUtil.dependsOnAndroidLibrary(dependencies, artifact);
    }

    public static boolean dependsOnJavaLibrary(AndroidModuleModel androidModel, String artifact) {
        IdeDependencies dependencies = androidModel.getSelectedMainCompileLevel2Dependencies();
        for (Library library : dependencies.getJavaLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOnAndroidTest(AndroidModuleModel androidModel, String artifact) {
        IdeDependencies dependencies = androidModel.getSelectedAndroidTestCompileDependencies();
        if (dependencies == null) {
            return false;
        }
        return GradleUtil.dependsOnAndroidLibrary(dependencies, artifact);
    }

    private static boolean dependsOnAndroidLibrary(IdeDependencies dependencies, String artifact) {
        for (Library library : dependencies.getAndroidLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOn(AndroidLibrary library, String artifact, boolean transitively) {
        return GradleUtil.getDependencyVersion(library, artifact, transitively) != null;
    }

    private static String getDependencyVersion(AndroidLibrary library, String artifact, boolean transitively) {
        MavenCoordinates resolvedCoordinates = library.getResolvedCoordinates();
        if (resolvedCoordinates != null && artifact.endsWith(resolvedCoordinates.getArtifactId()) && artifact.equals(resolvedCoordinates.getGroupId() + ':' + resolvedCoordinates.getArtifactId())) {
            return resolvedCoordinates.getVersion();
        }
        if (transitively) {
            for (AndroidLibrary dependency : library.getLibraryDependencies()) {
                String version2 = GradleUtil.getDependencyVersion(dependency, artifact, true);
                if (version2 == null) continue;
                return version2;
            }
        }
        return null;
    }

    public static boolean dependsOn(Library library, String artifact) {
        return GradleUtil.getDependencyVersion(library, artifact) != null;
    }

    private static String getDependencyVersion(Library library, String artifact) {
        GradleCoordinate resolvedCoordinates = GradleCoordinate.parseCoordinateString((String)library.getArtifactAddress());
        if (resolvedCoordinates != null && artifact.equals(resolvedCoordinates.getGroupId() + ':' + resolvedCoordinates.getArtifactId())) {
            return resolvedCoordinates.getRevision();
        }
        return null;
    }

    public static boolean hasCause(@NotNull Throwable e, @NotNull Class<?> causeClass) {
        String causeClassName = causeClass.getName();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!causeClassName.equals(ex.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static File getGradleUserSettingsFile() {
        String homePath = SystemProperties.getUserHome();
        if (homePath == null) {
            return null;
        }
        return new File(homePath, FileUtil.join((String[])new String[]{".gradle", "gradle.properties"}));
    }

    public static void setBuildToolsVersion(@NotNull Project project, @NotNull String version2) {
        ArrayList modelsToUpdate = Lists.newArrayList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModel android;
            GradleBuildModel buildModel;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || (buildModel = GradleBuildModel.get(module)) == null || version2.equals((android = buildModel.android()).buildToolsVersion().toString())) continue;
            android.buildToolsVersion().setValue(version2);
            modelsToUpdate.add(buildModel);
        }
        if (!modelsToUpdate.isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                for (GradleBuildModel buildModel : modelsToUpdate) {
                    buildModel.applyChanges();
                }
            });
        }
    }

    @Nullable
    public static Library findLibrary(@NotNull File bundleDir, @NotNull IdeVariant variant) {
        IdeAndroidArtifact artifact = variant.getMainArtifact();
        IdeDependencies dependencies = artifact.getLevel2Dependencies();
        for (Library library : dependencies.getAndroidLibraries()) {
            if (!FileUtil.filesEqual((File)bundleDir, (File)library.getFolder())) continue;
            return library;
        }
        return null;
    }

    @NotNull
    public static String mapConfigurationName(@NotNull String configuration, @Nullable GradleVersion pluginVersion, boolean preferApi) {
        return GradleUtil.mapConfigurationName(configuration, pluginVersion != null ? pluginVersion.toString() : null, preferApi);
    }

    @NotNull
    public static String mapConfigurationName(@NotNull String configuration, @Nullable String pluginVersion, boolean preferApi) {
        boolean compatibilityNames = pluginVersion != null && PLUGIN_VERSION_PATTERN.matcher(pluginVersion).matches();
        return GradleUtil.mapConfigurationName(configuration, compatibilityNames, preferApi);
    }

    @NotNull
    private static String mapConfigurationName(@NotNull String configuration, boolean useCompatibilityNames, boolean preferApi) {
        if (useCompatibilityNames) {
            return configuration;
        }
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "compile", preferApi ? "api" : "implementation");
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "provided", "compileOnly");
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "apk", "runtimeOnly");
        return configuration;
    }

    public static boolean useCompatibilityConfigurationNames(@NotNull Project project) {
        return GradleUtil.useCompatibilityConfigurationNames(GradleUtil.getAndroidGradleModelVersionInUse(project));
    }

    public static boolean useCompatibilityConfigurationNames(@Nullable GradleVersion gradleVersion2) {
        return gradleVersion2 != null && gradleVersion2.getMajor() < 3;
    }

    private static String replaceSuffixWithCase(String s, String suffix, String newSuffix) {
        if (SdkUtils.endsWithIgnoreCase((String)s, (String)suffix)) {
            int suffixBegin = s.length() - suffix.length();
            if (Character.isUpperCase(s.charAt(suffixBegin))) {
                return s.substring(0, suffixBegin) + Character.toUpperCase(newSuffix.charAt(0)) + newSuffix.substring(1);
            }
            if (suffixBegin == 0) {
                return newSuffix;
            }
            return s.substring(0, suffixBegin) + suffix;
        }
        return s;
    }

    public static boolean isAaptGeneratedSourcesFolder(@NotNull File folder, @NotNull File buildFolder) {
        File generatedFolder = new File(buildFolder, "generated");
        File generatedSourceR = FileUtils.join((File)generatedFolder, (String[])new String[]{"source", "r"});
        File rClassSources = new File(generatedFolder, "not_namespaced_r_class_sources");
        return FileUtil.isAncestor((File)generatedSourceR, (File)folder, (boolean)false) || FileUtil.isAncestor((File)rClassSources, (File)folder, (boolean)false);
    }

    @VisibleForTesting
    public static boolean isDataBindingGeneratedBaseClassesFolder(@NotNull File folder, @NotNull File buildFolder) {
        File generatedFolder = new File(buildFolder, "generated");
        File dataBindingSources = new File(generatedFolder, "data_binding_base_class_source_out");
        return FileUtil.isAncestor((File)dataBindingSources, (File)folder, (boolean)false);
    }

    public static Collection<File> getGeneratedSourceFoldersToUse(@NotNull IdeBaseArtifact artifact, @NotNull AndroidModuleModel model2) {
        File buildFolder = model2.getAndroidProject().getBuildFolder();
        return artifact.getGeneratedSourceFolders().stream().filter(folder -> !GradleUtil.isAaptGeneratedSourcesFolder(folder, buildFolder)).filter(folder -> !GradleUtil.isDataBindingGeneratedBaseClassesFolder(folder, buildFolder)).collect(Collectors.toList());
    }

    public static Set<String> projectBuildFilesTypes(@NotNull Project project) {
        HashSet<String> result2 = new HashSet<String>();
        GradleUtil.addBuildFileType(result2, GradleUtil.getGradleBuildFile(Projects.getBaseDirPath((Project)project)));
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GradleUtil.addBuildFileType(result2, GradleUtil.getGradleBuildFile(module));
        }
        return result2;
    }

    public static boolean hasKtsBuildFiles(@NotNull Project project) {
        return GradleUtil.projectBuildFilesTypes(project).contains(".kts");
    }

    public static boolean isKtsFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        HashSet<String> result2 = new HashSet<String>();
        GradleUtil.addBuildFileType(result2, file);
        return result2.contains(".kts");
    }

    private static void addBuildFileType(@NotNull HashSet<String> result2, @Nullable VirtualFile buildFile) {
        if (buildFile != null) {
            String buildFileExtension = buildFile.getExtension();
            if (buildFileExtension == null) {
                return;
            }
            buildFileExtension = "." + buildFileExtension;
            if (buildFileExtension.equalsIgnoreCase(".gradle")) {
                result2.add(".gradle");
            } else if (buildFileExtension.equalsIgnoreCase(".kts")) {
                result2.add(".kts");
            }
        }
    }

    @Nullable
    public static String getLastKnownAndroidGradlePluginVersion(@NotNull Project project) {
        for (Module module : ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(GradleFacet.getFacetTypeId())) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null) continue;
            GradleFacetConfiguration configuration = (GradleFacetConfiguration)gradleFacet.getConfiguration();
            String version2 = configuration.LAST_KNOWN_AGP_VERSION;
            if (version2 == null) continue;
            return version2;
        }
        return null;
    }

    @Nullable
    public static String getLastSuccessfulAndroidGradlePluginVersion(@NotNull Project project) {
        for (Module module : ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(GradleFacet.getFacetTypeId())) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null) continue;
            GradleFacetConfiguration configuration = (GradleFacetConfiguration)gradleFacet.getConfiguration();
            String version2 = configuration.LAST_SUCCESSFUL_SYNC_AGP_VERSION;
            if (version2 == null) continue;
            return version2;
        }
        return null;
    }
}

